/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;

public abstract class AbstractResourcesRegistry
implements IResourcesRegistry {
    private Map<Object, Map<Object, Object>> allResourcesMap;

    @Override
    public Object getResource(Object type, Object key) {
        if (this.allResourcesMap == null) {
            return null;
        }
        Map<Object, Object> resourcesMap = this.allResourcesMap.get(type);
        if (resourcesMap == null) {
            return null;
        }
        return resourcesMap.get(key);
    }

    @Override
    public void registerResource(Object type, Object key, Object resource) {
        Map<Object, Object> resourcesMap;
        if (this.allResourcesMap == null) {
            this.allResourcesMap = new HashMap<Object, Map<Object, Object>>();
        }
        if ((resourcesMap = this.allResourcesMap.get(type)) == null) {
            resourcesMap = new HashMap<Object, Object>();
            this.allResourcesMap.put(type, resourcesMap);
        }
        resourcesMap.put(key, resource);
    }

    protected Map<Object, Object> getCacheByType(Object type) {
        Map<Object, Object> resourcesMap;
        if (this.allResourcesMap != null && (resourcesMap = this.allResourcesMap.get(type)) != null) {
            return resourcesMap;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void unregisterResource(Object type, Object key) {
        if (this.allResourcesMap == null) {
            return;
        }
        Map<Object, Object> resourcesMap = this.allResourcesMap.get(type);
        if (resourcesMap == null) {
            return;
        }
        Object resource = resourcesMap.get(key);
        if (resource != null) {
            resourcesMap.remove(resource);
        }
    }

    public void unregisterResource(Object resource) {
        Map<Object, Object> resourcesMap;
        Object type = this.getResourceType(resource);
        if (type != null && (resourcesMap = this.allResourcesMap.get(type)) != null) {
            resourcesMap.remove(resource);
        }
    }

    public Object getResourceType(Object resource) {
        return resource.getClass();
    }

    @Override
    public void dispose() {
        if (this.allResourcesMap == null) {
            return;
        }
        Set<Map.Entry<Object, Map<Object, Object>>> allResources = this.allResourcesMap.entrySet();
        for (Map.Entry<Object, Map<Object, Object>> entry : allResources) {
            Object type = entry.getKey();
            Set<Map.Entry<Object, Object>> resources = entry.getValue().entrySet();
            for (Map.Entry<Object, Object> entry2 : resources) {
                this.disposeResource(type, entry2.getKey(), entry2.getValue());
            }
        }
        this.allResourcesMap = null;
    }

    public abstract void disposeResource(Object var1, Object var2, Object var3);
}

