/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomEvent
extends TmfEvent {
    protected static final String TIMESTAMP_INPUT_FORMAT_KEY = "CE_TS_I_F";
    protected static final String NO_MESSAGE = "";
    @NonNull
    private ITmfTimestamp customEventTimestamp;
    private ITmfEventField customEventContent;
    private ITmfEventType customEventType;
    protected CustomTraceDefinition fDefinition;
    protected Map<String, String> fData;
    private TmfEventField[] fColumnData;

    public CustomEvent(CustomTraceDefinition definition) {
        super(null, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = TmfTimestamp.ZERO;
    }

    public CustomEvent(CustomTraceDefinition definition, @NonNull TmfEvent other) {
        super(other);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = other.getTimestamp();
        this.customEventContent = other.getContent();
        this.customEventType = other.getType();
    }

    public CustomEvent(CustomTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, TmfEventType type) {
        super(parentTrace, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = timestamp == null ? TmfTimestamp.ZERO : timestamp;
        this.customEventContent = null;
        this.customEventType = type;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventTimestamp;
    }

    @Override
    public ITmfEventField getContent() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventContent;
    }

    @Override
    public ITmfEventType getType() {
        return this.customEventType;
    }

    protected void setTimestamp(@NonNull ITmfTimestamp timestamp) {
        this.customEventTimestamp = timestamp;
    }

    protected void setContent(ITmfEventField content) {
        this.customEventContent = content;
    }

    protected void setType(ITmfEventType type) {
        this.customEventType = type;
    }

    Object getContentValue() {
        return this.customEventContent.getValue();
    }

    public String getEventString(int index) {
        if (this.fData != null) {
            this.processData();
        }
        if (index < 0 || index >= this.fColumnData.length) {
            return NO_MESSAGE;
        }
        return this.fColumnData[index].getValue().toString();
    }

    private void processData() {
        String timestampString = this.fData.get(CustomTraceDefinition.TAG_TIMESTAMP);
        String timestampInputFormat = this.fData.get(TIMESTAMP_INPUT_FORMAT_KEY);
        TmfNanoTimestamp timestamp = null;
        if (timestampInputFormat != null && timestampString != null) {
            TmfTimestampFormat timestampFormat = new TmfTimestampFormat(timestampInputFormat);
            try {
                long time = timestampFormat.parseValue(timestampString);
                timestamp = new TmfNanoTimestamp(this.getTrace().getTimestampTransform().transform(time));
                this.setTimestamp(timestamp);
            }
            catch (ParseException e) {
                this.setTimestamp(TmfTimestamp.ZERO);
            }
        } else {
            this.setTimestamp(TmfTimestamp.ZERO);
        }
        int i = 0;
        this.fColumnData = new TmfEventField[this.fDefinition.outputs.size()];
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            String value = this.fData.get(outputColumn.name);
            if (outputColumn.name.equals(CustomTraceDefinition.TAG_TIMESTAMP) && timestamp != null) {
                TmfTimestampFormat timestampFormat = new TmfTimestampFormat(this.fDefinition.timeStampOutputFormat);
                this.fColumnData[i++] = new TmfEventField(outputColumn.name, timestampFormat.format(timestamp.getValue()), null);
                continue;
            }
            this.fColumnData[i++] = new TmfEventField(outputColumn.name, value != null ? value : NO_MESSAGE, null);
        }
        this.setContent(new CustomEventContent(this.customEventContent.getName(), this.customEventContent.getValue(), this.fColumnData));
        this.fData = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fDefinition == null ? 0 : this.fDefinition.hashCode());
        result = 31 * result + this.customEventTimestamp.hashCode();
        result = 31 * result + (this.customEventContent == null ? 0 : this.customEventContent.hashCode());
        result = 31 * result + (this.customEventType == null ? 0 : this.customEventType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CustomEvent)) {
            return false;
        }
        CustomEvent other = (CustomEvent)obj;
        if (!NonNullUtils.equalsNullable((Object)this.fDefinition, (Object)other.fDefinition)) {
            return false;
        }
        if (!this.customEventTimestamp.equals(other.customEventTimestamp)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.customEventContent, (Object)other.customEventContent)) {
            return false;
        }
        return NonNullUtils.equalsNullable((Object)this.customEventType, (Object)other.customEventType);
    }
}

