/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.analysis;

import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.btf.core.trace.BtfTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class BtfStateProvider
extends AbstractTmfStateProvider {
    private static final int PROVIDER_VERSION = 3;
    private static final TmfNamedStateValue STATE_CORE_IDLE = new TmfNamedStateValue(TmfStateValue.newValueInt((int)0), "Idle");
    private static final TmfNamedStateValue STATE_NOT_RUNNING = new TmfNamedStateValue(TmfStateValue.nullValue(), "Not Running");
    private static final TmfNamedStateValue STATE_RUNNING = new TmfNamedStateValue(TmfStateValue.newValueInt((int)1), "RUNNING");
    private static final TmfNamedStateValue STATE_SUSPENDED = new TmfNamedStateValue(TmfStateValue.newValueInt((int)2), "SUSPENDED");
    private static final TmfNamedStateValue STATE_TASK_ACTIVE = new TmfNamedStateValue(TmfStateValue.newValueInt((int)4), "Active");
    private static final TmfNamedStateValue STATE_TASK_READY = new TmfNamedStateValue(TmfStateValue.newValueInt((int)5), "Ready");
    private static final TmfNamedStateValue STATE_TASK_RUNNING = new TmfNamedStateValue(TmfStateValue.newValueInt((int)6), "Task Running");
    private static final TmfNamedStateValue STATE_TASK_WAITING = new TmfNamedStateValue(TmfStateValue.newValueInt((int)7), "Waiting");
    private static final TmfNamedStateValue STATE_TASK_PARKING = new TmfNamedStateValue(TmfStateValue.newValueInt((int)8), "Parking");
    private static final TmfNamedStateValue STATE_TASK_POLLING = new TmfNamedStateValue(TmfStateValue.newValueInt((int)9), "Polling");
    private static final TmfNamedStateValue STATE_TASK_TERMINATED = new TmfNamedStateValue(TmfStateValue.nullValue(), "Terminated");
    private static final String ENTITY_CORE = "Core";
    private static final String ENTITY_TASK = "TASK";
    private static final String ATTRIBUTE_TASKS = "Tasks";
    private static final String ATTRIBUTE_CORES = "Cores";
    private static final String ATTRIBUTE_ACTIVE_CORE = "ActiveCore";

    public BtfStateProvider(BtfTrace trace) {
        super((ITmfTrace)trace, "Btf State Provider");
    }

    public BtfTrace getTrace() {
        return (BtfTrace)super.getTrace();
    }

    public int getVersion() {
        return 3;
    }

    public ITmfStateProvider getNewInstance() {
        return new BtfStateProvider(this.getTrace());
    }

    protected void eventHandle(ITmfEvent ev) {
        if (!(ev instanceof BtfEvent)) {
            return;
        }
        BtfEvent event = (BtfEvent)ev;
        ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long ts = event.getTimestamp().getValue();
        String eventType = (String)event.getContent().getField(new String[]{BtfColumnNames.EVENT.toString()}).getValue();
        String source = event.getSource();
        String target = event.getTarget();
        try {
            switch (eventType) {
                case "activate": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_ACTIVE);
                    break;
                }
                case "resume": 
                case "start": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_RUNNING);
                    if (source.startsWith(ENTITY_CORE)) {
                        String core = source;
                        String task = target;
                        int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, core});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_RUNNING.getValue(), quark);
                        quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, ATTRIBUTE_ACTIVE_CORE});
                        TmfStateValue value = TmfStateValue.newValueString((String)core);
                        ssb.modifyAttribute(ts, (ITmfStateValue)value, quark);
                        quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_CORES, core});
                        value = STATE_RUNNING.getValue();
                        ssb.modifyAttribute(ts, (ITmfStateValue)value, quark);
                        break;
                    }
                    if (source.startsWith(ENTITY_TASK)) {
                        String task = source;
                        String runnable = target;
                        String core = BtfStateProvider.getCoreOfTask(ssb, task);
                        int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, core, runnable});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_RUNNING.getValue(), quark);
                    }
                    break;
                }
                case "suspend": {
                    if (source.startsWith(ENTITY_TASK)) {
                        String task = source;
                        String runnable = target;
                        String core = BtfStateProvider.getCoreOfTask(ssb, task);
                        int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, core});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_SUSPENDED.getValue(), quark);
                        quark = ssb.getQuarkRelativeAndAdd(quark, new String[]{runnable});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_SUSPENDED.getValue(), quark);
                    }
                    break;
                }
                case "terminate": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_TERMINATED);
                    if (source.startsWith(ENTITY_CORE)) {
                        String core = source;
                        String task = target;
                        int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, core});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_NOT_RUNNING.getValue(), quark);
                        quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, ATTRIBUTE_ACTIVE_CORE});
                        TmfStateValue value = TmfStateValue.nullValue();
                        ssb.modifyAttribute(ts, (ITmfStateValue)value, quark);
                        quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_CORES, core});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_CORE_IDLE.getValue(), quark);
                        break;
                    }
                    if (source.startsWith(ENTITY_TASK)) {
                        String task = source;
                        String runnable = target;
                        String core = BtfStateProvider.getCoreOfTask(ssb, task);
                        int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task, core, runnable});
                        ssb.modifyAttribute(ts, (ITmfStateValue)STATE_NOT_RUNNING.getValue(), quark);
                    }
                    break;
                }
                case "release_parking": 
                case "preempt": 
                case "release": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_READY);
                    break;
                }
                case "wait": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_WAITING);
                    break;
                }
                case "park": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_PARKING);
                    break;
                }
                case "poll_parking": 
                case "poll": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_POLLING);
                    break;
                }
                case "run": {
                    BtfStateProvider.updateTaskStateSystem(ssb, ts, event, STATE_TASK_RUNNING);
                    break;
                }
            }
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void updateTaskStateSystem(ITmfStateSystemBuilder ssb, long ts, BtfEvent event, TmfNamedStateValue stateValue) throws AttributeNotFoundException {
        String name = event.getName();
        if (name.equals("Task")) {
            String task = event.getTarget();
            int quark = ssb.getQuarkAbsoluteAndAdd(new String[]{ATTRIBUTE_TASKS, task});
            ssb.modifyAttribute(ts, (ITmfStateValue)stateValue.getValue(), quark);
        }
    }

    private static String getCoreOfTask(ITmfStateSystemBuilder ssb, String task) {
        try {
            int quark = ssb.getQuarkAbsolute(new String[]{ATTRIBUTE_TASKS, task, ATTRIBUTE_ACTIVE_CORE});
            ITmfStateValue value = ssb.queryOngoingState(quark);
            return value.unboxStr();
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TmfNamedStateValue {
        private final String fName;
        private final TmfStateValue fValue;

        public TmfNamedStateValue(TmfStateValue value, String name) {
            this.fValue = value;
            this.fName = name;
        }

        public TmfStateValue getValue() {
            return this.fValue;
        }

        public String toString() {
            return this.fName;
        }
    }
}

