/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.trace;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public enum BtfTimestampFormat {
    PS("ps", -12, 0.001),
    NS("ns", -9, 1.0),
    US("us", -6, 1000.0),
    MS("ms", -3, 1000000.0),
    S("s", 0, 1.0E9);

    private final String fName;
    private final int fScale;
    private final double fScaleFactor;

    private BtfTimestampFormat(String name, int scale, double scaleFactor) {
        this.fName = name;
        this.fScale = scale;
        this.fScaleFactor = scaleFactor;
    }

    public double getScaleFactor() {
        return this.fScaleFactor;
    }

    public String toString() {
        return this.fName;
    }

    public static BtfTimestampFormat parse(String text) {
        switch (text.toLowerCase()) {
            case "ps": {
                throw new IllegalArgumentException("ps not yet supported");
            }
            case "ns": {
                return NS;
            }
            case "us": {
                return US;
            }
            case "ms": {
                return MS;
            }
            case "s": {
                return S;
            }
        }
        throw new IllegalArgumentException(String.valueOf(text) + " not a valid argument, use ps, ns, us, ms, s");
    }

    @NonNull
    public ITmfTimestamp createTimestamp(long timestamp) {
        return new TmfTimestamp(timestamp, this.fScale);
    }
}

