/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.util.IUnaryPredicate;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Iterator<T> reverseIterator(List<T> list) {
        return new Iterator<T>(list){
            ListIterator<T> iterator;
            {
                this.iterator = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasPrevious();
            }

            @Override
            public T next() {
                return this.iterator.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported");
            }
        };
    }

    public static <T> Iterable<T> reverseIterable(List<T> list) {
        return CollectionUtils.iterable(CollectionUtils.reverseIterator(list));
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iter) {
        if (iter == null) {
            throw new NullPointerException("iter parameter is null");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static <T> T findFirstAndRemove(List<?> list, Class<T> clazz) {
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!clazz.isInstance(o)) continue;
            iter.remove();
            return (T)o;
        }
        return null;
    }

    public static <T, U extends Collection<T>> U merge(U c1, U c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isEmpty()) {
            return c2;
        }
        if (c2.isEmpty()) {
            return c1;
        }
        c1.addAll(c2);
        return c1;
    }

    public static <T, U> List<U> listMapGet(Map<T, List<U>> m, T t) {
        List<U> result = m.get(t);
        if (result == null) {
            result = new ArrayList<U>();
            m.put(t, result);
        }
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, IUnaryPredicate<T> predicate) {
        if (collection.isEmpty()) {
            return collection;
        }
        ArrayList<T> result = null;
        int n = 0;
        block0: for (T t : collection) {
            if (predicate.apply(t)) {
                if (result != null) {
                    result.add(t);
                    continue;
                }
                ++n;
                continue;
            }
            if (result != null) continue;
            result = new ArrayList<T>(collection.size() - 1);
            for (T u : collection) {
                if (--n < 0) continue block0;
                result.add(u);
            }
        }
        return result == null ? collection : result;
    }
}

