/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToNumberConverter
extends NumberFormatConverter {
    private Class<?> toType;
    private NumberFormat numberFormat;
    private final Number min;
    private final Number max;
    private final Class<?> boxedType;
    private static final Integer MIN_INTEGER = new Integer(Integer.MIN_VALUE);
    private static final Integer MAX_INTEGER = new Integer(Integer.MAX_VALUE);
    private static final Double MIN_DOUBLE = new Double(-1.7976931348623157E308);
    private static final Double MAX_DOUBLE = new Double(Double.MAX_VALUE);
    private static final Long MIN_LONG = new Long(Long.MIN_VALUE);
    private static final Long MAX_LONG = new Long(Long.MAX_VALUE);
    private static final Float MIN_FLOAT = new Float(-3.4028235E38f);
    private static final Float MAX_FLOAT = new Float(Float.MAX_VALUE);
    private static final Short MIN_SHORT = new Short(Short.MIN_VALUE);
    private static final Short MAX_SHORT = new Short(Short.MAX_VALUE);
    private static final Byte MIN_BYTE = new Byte(-128);
    private static final Byte MAX_BYTE = new Byte(127);
    static Class<?> icuBigDecimal = null;
    static Method icuBigDecimalScale = null;
    static Method icuBigDecimalUnscaledValue = null;

    private StringToNumberConverter(NumberFormat numberFormat, Class<?> toType, Number min, Number max, Class<?> boxedType) {
        super(String.class, toType, numberFormat);
        try {
            icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            icuBigDecimalScale = icuBigDecimal.getMethod("scale", new Class[0]);
            icuBigDecimalUnscaledValue = icuBigDecimal.getMethod("unscaledValue", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.toType = toType;
        this.numberFormat = numberFormat;
        this.min = min;
        this.max = max;
        this.boxedType = boxedType;
    }

    @Override
    public Object convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.toType.isPrimitive());
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (Integer.class.equals(this.boxedType)) {
            if (StringToNumberParser.inIntegerRange(result.getNumber())) {
                return new Integer(result.getNumber().intValue());
            }
        } else if (Double.class.equals(this.boxedType)) {
            if (StringToNumberParser.inDoubleRange(result.getNumber())) {
                return new Double(result.getNumber().doubleValue());
            }
        } else if (Long.class.equals(this.boxedType)) {
            if (StringToNumberParser.inLongRange(result.getNumber())) {
                return new Long(result.getNumber().longValue());
            }
        } else if (Float.class.equals(this.boxedType)) {
            if (StringToNumberParser.inFloatRange(result.getNumber())) {
                return new Float(result.getNumber().floatValue());
            }
        } else {
            if (BigInteger.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return BigInteger.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return n;
                }
                if (n instanceof BigDecimal) {
                    return ((BigDecimal)n).toBigInteger();
                }
                return new BigDecimal(n.doubleValue()).toBigInteger();
            }
            if (BigDecimal.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return BigDecimal.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return new BigDecimal((BigInteger)n);
                }
                if (n instanceof BigDecimal) {
                    return n;
                }
                if (icuBigDecimal != null && icuBigDecimal.isInstance(n)) {
                    try {
                        int scale = (Integer)icuBigDecimalScale.invoke((Object)n, new Object[0]);
                        BigInteger unscaledValue = (BigInteger)icuBigDecimalUnscaledValue.invoke((Object)n, new Object[0]);
                        return new BigDecimal(unscaledValue, scale);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException("Error (IllegalAccessException) converting BigDecimal using ICU");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IllegalArgumentException("Error (InvocationTargetException) converting BigDecimal using ICU");
                    }
                }
                if (n instanceof Double) {
                    BigDecimal bd = new BigDecimal(n.doubleValue());
                    if (bd.scale() == 0) {
                        return bd;
                    }
                    throw new IllegalArgumentException("Non-integral Double value returned from NumberFormat which cannot be accurately stored in a BigDecimal due to lost precision. Consider using ICU4J or Java 5 which can properly format and parse these types.");
                }
            } else if (Short.class.equals(this.boxedType)) {
                if (StringToNumberParser.inShortRange(result.getNumber())) {
                    return new Short(result.getNumber().shortValue());
                }
            } else if (Byte.class.equals(this.boxedType) && StringToNumberParser.inByteRange(result.getNumber())) {
                return new Byte(result.getNumber().byteValue());
            }
        }
        if (this.min != null && this.max != null) {
            throw new IllegalArgumentException(StringToNumberParser.createOutOfRangeMessage(this.min, this.max, this.numberFormat));
        }
        throw new IllegalArgumentException("Could not convert [" + fromObject + "] to type [" + this.toType + "]");
    }

    public static StringToNumberConverter toInteger(boolean primitive) {
        return StringToNumberConverter.toInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toInteger(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Integer.TYPE : Integer.class, MIN_INTEGER, MAX_INTEGER, Integer.class);
    }

    public static StringToNumberConverter toDouble(boolean primitive) {
        return StringToNumberConverter.toDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toDouble(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Double.TYPE : Double.class, MIN_DOUBLE, MAX_DOUBLE, Double.class);
    }

    public static StringToNumberConverter toLong(boolean primitive) {
        return StringToNumberConverter.toLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toLong(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Long.TYPE : Long.class, MIN_LONG, MAX_LONG, Long.class);
    }

    public static StringToNumberConverter toFloat(boolean primitive) {
        return StringToNumberConverter.toFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toFloat(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Float.TYPE : Float.class, MIN_FLOAT, MAX_FLOAT, Float.class);
    }

    public static StringToNumberConverter toBigInteger() {
        return StringToNumberConverter.toBigInteger(NumberFormat.getIntegerInstance());
    }

    public static StringToNumberConverter toBigInteger(NumberFormat numberFormat) {
        return new StringToNumberConverter(numberFormat, BigInteger.class, null, null, BigInteger.class);
    }

    public static StringToNumberConverter toBigDecimal() {
        return StringToNumberConverter.toBigDecimal(NumberFormat.getNumberInstance());
    }

    public static StringToNumberConverter toBigDecimal(NumberFormat numberFormat) {
        return new StringToNumberConverter(numberFormat, BigDecimal.class, null, null, BigDecimal.class);
    }

    public static StringToNumberConverter toShort(boolean primitive) {
        return StringToNumberConverter.toShort(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toShort(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Short.TYPE : Short.class, MIN_SHORT, MAX_SHORT, Short.class);
    }

    public static StringToNumberConverter toByte(boolean primitive) {
        return StringToNumberConverter.toByte(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toByte(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Byte.TYPE : Byte.class, MIN_BYTE, MAX_BYTE, Byte.class);
    }
}

