/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public final class TmfTimePreferences {
    private static final String DATIME_DEFAULT = "HH:mm:ss";
    private static final String SUBSEC_DEFAULT = "SSS SSS SSS";
    private static final String DATE_DELIMITER_DEFAULT = "-";
    private static final String TIME_DELIMITER_DEFAULT = ":";
    private static final String SSEC_DELIMITER_DEFAULT = " ";
    private static final String TIME_ZONE_DEFAULT = TimeZone.getDefault().getID();

    private TmfTimePreferences() {
    }

    public static void init() {
        IEclipsePreferences defaultPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", DATIME_DEFAULT);
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", SUBSEC_DEFAULT);
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.date.delimiter", DATE_DELIMITER_DEFAULT);
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.time.delimiter", TIME_DELIMITER_DEFAULT);
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.ssec.delimiter", SSEC_DELIMITER_DEFAULT);
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", TIME_ZONE_DEFAULT);
        TmfTimestampFormat.updateDefaultFormats();
    }

    public static String getTimePattern() {
        return TmfTimePreferences.computeTimePattern(TmfTimePreferences.getPreferenceMap(false));
    }

    public static String getIntervalPattern() {
        return TmfTimePreferences.computeIntervalPattern(TmfTimePreferences.getPreferenceMap(false));
    }

    public static TimeZone getTimeZone() {
        return TimeZone.getTimeZone(Platform.getPreferencesService().getString("org.eclipse.tracecompass.tmf.core", "org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", TimeZone.getDefault().getID(), null));
    }

    public static Locale getLocale() {
        return Locale.forLanguageTag(Platform.getPreferencesService().getString("org.eclipse.tracecompass.tmf.core", "org.eclipse.linuxtools.tmf.core.prefs.time.format.locale", Locale.getDefault().toLanguageTag(), null));
    }

    public static Map<String, String> getDefaultPreferenceMap() {
        return TmfTimePreferences.getPreferenceMap(true);
    }

    public static Map<String, String> getPreferenceMap() {
        return TmfTimePreferences.getPreferenceMap(false);
    }

    private static Map<String, String> getPreferenceMap(boolean defaultValues) {
        HashMap<String, String> prefsMap = new HashMap<String, String>();
        IEclipsePreferences prefs = defaultValues ? DefaultScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core") : InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", SUBSEC_DEFAULT);
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.time.delimiter", TIME_DELIMITER_DEFAULT);
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.ssec.delimiter", SSEC_DELIMITER_DEFAULT);
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", DATIME_DEFAULT);
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.date.delimiter", DATE_DELIMITER_DEFAULT);
        TmfTimePreferences.prefToMap(prefs, prefsMap, "org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", TIME_ZONE_DEFAULT);
        return prefsMap;
    }

    private static String computeIntervalPattern(Map<String, String> prefsMap) {
        String ssecFmt = TmfTimePreferences.computeSubSecFormat(prefsMap);
        return "TTT." + ssecFmt;
    }

    private static String computeSubSecFormat(Map<String, String> prefsMap) {
        String sSecFormat = prefsMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec");
        String sSecFieldSep = prefsMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.ssec.delimiter");
        String ssecFmt = sSecFormat.replaceAll(SSEC_DELIMITER_DEFAULT, sSecFieldSep);
        return ssecFmt;
    }

    private static void prefToMap(IEclipsePreferences node, Map<String, String> prefsMap, String key, String defaultValue) {
        prefsMap.put(key, node.get(key, defaultValue));
    }

    public static String computeTimePattern(Map<String, String> prefsMap) {
        String timeFormat;
        String dateFormat;
        int index;
        String dateTimeFormat = prefsMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
        if (dateTimeFormat == null) {
            dateTimeFormat = "HH:mm:ss.SSS SSS SSS";
        }
        if ((index = dateTimeFormat.indexOf(32)) != -1) {
            dateFormat = dateTimeFormat.substring(0, dateTimeFormat.indexOf(32) + 1);
            timeFormat = dateTimeFormat.substring(dateFormat.length());
        } else {
            dateFormat = "";
            timeFormat = dateTimeFormat;
        }
        String dateFieldSep = prefsMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.date.delimiter");
        String timeFieldSep = prefsMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.time.delimiter");
        String dateFmt = dateFormat.replaceAll(DATE_DELIMITER_DEFAULT, dateFieldSep);
        String timeFmt = timeFormat.replaceAll(TIME_DELIMITER_DEFAULT, timeFieldSep);
        String ssecFmt = TmfTimePreferences.computeSubSecFormat(prefsMap);
        return String.valueOf(dateFmt) + timeFmt + (ssecFmt.equals("") ? "" : String.valueOf('.') + ssecFmt);
    }
}

