/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewIdRegistry;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewMemoryViewAction
implements IViewActionDelegate {
    private MemoryView fView;

    public void init(IViewPart view) {
        if (view instanceof MemoryView) {
            this.fView = (MemoryView)view;
        }
    }

    public void run(IAction action) {
        String secondaryId = MemoryViewIdRegistry.getUniqueSecondaryId("org.eclipse.debug.ui.MemoryView");
        try {
            IWorkbenchPage page = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart newView = page.showView("org.eclipse.debug.ui.MemoryView", secondaryId, 1);
            this.setInitialSelection(newView);
            this.setInitialViewSettings(newView);
        }
        catch (PartInitException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void setInitialSelection(IViewPart newView) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return;
            }
            if (obj instanceof IMemoryRendering) {
                IMemoryBlock memBlock = ((IMemoryRendering)obj).getMemoryBlock();
                strucSel = new StructuredSelection((Object)memBlock);
                newView.getSite().getSelectionProvider().setSelection((ISelection)strucSel);
            } else if (obj instanceof IMemoryBlock) {
                newView.getSite().getSelectionProvider().setSelection((ISelection)strucSel);
            }
        }
    }

    private void setInitialViewSettings(IViewPart newView) {
        if (this.fView != null && newView instanceof MemoryView) {
            MemoryView newMView = (MemoryView)newView;
            IMemoryViewPane[] viewPanes = this.fView.getViewPanes();
            int orientation = this.fView.getViewPanesOrientation();
            int i = 0;
            while (i < viewPanes.length) {
                newMView.showViewPane(this.fView.isViewPaneVisible(viewPanes[i].getId()), viewPanes[i].getId());
                ++i;
            }
            newMView.setViewPanesOrientation(orientation);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

