/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class SortFieldContribution
extends MarkersContribution {
    public SortFieldContribution() {
    }

    public SortFieldContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ExtendedMarkersView view = this.getView();
        if (view == null) {
            return new IContributionItem[0];
        }
        MarkerField[] fields = view.getVisibleFields();
        if (fields.length == 0) {
            return new IContributionItem[0];
        }
        IContributionItem[] items = new IContributionItem[fields.length + 2];
        int i = 0;
        while (i < fields.length) {
            items[i] = this.getContributionItem(fields[i]);
            ++i;
        }
        items[fields.length] = new Separator();
        items[fields.length + 1] = this.getDirectionContribution();
        return items;
    }

    private IContributionItem getDirectionContribution() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 32);
                item.setText(MarkerMessages.sortDirectionAscending_text);
                final ExtendedMarkersView view = SortFieldContribution.this.getView();
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (view != null) {
                            view.toggleSortDirection();
                        }
                    }
                });
                if (view != null) {
                    item.setSelection(view.getSortAscending());
                }
            }
        };
    }

    private IContributionItem getContributionItem(final MarkerField field) {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 16);
                String title = field.getName();
                item.setText(title);
                ExtendedMarkersView view = SortFieldContribution.this.getView();
                item.addListener(13, this.getMenuItemListener(field, view));
                if (view != null) {
                    item.setSelection(view.isPrimarySortField(field));
                }
            }

            private Listener getMenuItemListener(final MarkerField field2, final ExtendedMarkersView view) {
                return new Listener(){

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        if (item.getSelection() && view != null) {
                            view.setPrimarySortField(field2);
                        }
                    }
                };
            }
        };
    }
}

