/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;

class FileFileSystemObject
implements IFileSystemObject {
    private File fFileSystemObject;

    FileFileSystemObject(File fileSystemObject) {
        this.fFileSystemObject = fileSystemObject;
    }

    @Override
    public String getName() {
        String name = this.fFileSystemObject.getName();
        if (name.length() == 0) {
            return this.fFileSystemObject.getPath();
        }
        return name;
    }

    @Override
    public String getAbsolutePath() {
        return this.fFileSystemObject.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.fFileSystemObject.exists();
    }

    @Override
    public String getSourceLocation() {
        String sourceLocation = null;
        Object sourceResource = this.fFileSystemObject.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)this.fFileSystemObject.getAbsolutePath())) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)this.fFileSystemObject.getAbsolutePath()));
        if (sourceResource != null && sourceResource.exists()) {
            try {
                sourceLocation = sourceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (sourceLocation == null) {
            try {
                sourceLocation = URIUtil.toUnencodedString((URI)this.fFileSystemObject.getCanonicalFile().toURI());
            }
            catch (IOException e) {
                sourceLocation = URIUtil.toUnencodedString((URI)this.fFileSystemObject.toURI());
            }
        }
        return sourceLocation;
    }

    @Override
    public Object getRawFileSystemObject() {
        return this.fFileSystemObject;
    }
}

