/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;

public class TmfProjectElement
extends TmfProjectModelElement {
    private TmfTraceFolder fTraceFolder = null;
    private TmfExperimentFolder fExperimentFolder = null;

    public TmfProjectElement(String name, IProject project, ITmfProjectModelElement parent) {
        super(name, (IResource)project, parent);
    }

    public IProject getResource() {
        return (IProject)this.fResource;
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        super.addChild(child);
        if (child instanceof TmfTraceFolder) {
            this.fTraceFolder = (TmfTraceFolder)child;
            return;
        }
        if (child instanceof TmfExperimentFolder) {
            this.fExperimentFolder = (TmfExperimentFolder)child;
            return;
        }
    }

    public TmfTraceFolder getTracesFolder() {
        return this.fTraceFolder;
    }

    public TmfExperimentFolder getExperimentsFolder() {
        return this.fExperimentFolder;
    }

    @Override
    void refreshChildren() {
        ITmfProjectModelElement element;
        String name;
        IProject project = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element2 : this.getChildren()) {
            childrenMap.put(element2.getResource().getName(), element2);
        }
        IFolder folder = project.getFolder("Traces");
        if (folder != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfTracesFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfTracesFolder("Traces", folder, this);
            }
            ((TmfTracesFolder)element).refreshChildren();
        }
        if ((folder = project.getFolder("Experiments")) != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfExperimentFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfExperimentFolder("Experiments", folder, this);
            }
            ((TmfExperimentFolder)element).refreshChildren();
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    @Override
    public TmfProjectElement getProject() {
        return this;
    }
}

