/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;

public class FilterTreeLabelProvider
implements ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        String label = null;
        if (element instanceof TmfFilterNode) {
            TmfFilterNode node = (TmfFilterNode)element;
            label = String.valueOf(node.getNodeName()) + ' ' + (node.getFilterName() != null && !node.getFilterName().isEmpty() ? node.getFilterName() : Messages.FilterTreeLabelProvider_FilterNameHint);
        } else if (element instanceof TmfFilterTraceTypeNode) {
            TmfFilterTraceTypeNode node = (TmfFilterTraceTypeNode)element;
            label = "WITH " + node.getNodeName() + ' ' + (node.getName() != null ? node.getName() : Messages.FilterTreeLabelProvider_TraceTypeHint);
        } else if (element instanceof TmfFilterAndNode) {
            TmfFilterAndNode node = (TmfFilterAndNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + node.getNodeName();
        } else if (element instanceof TmfFilterOrNode) {
            TmfFilterOrNode node = (TmfFilterOrNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + node.getNodeName();
        } else if (element instanceof TmfFilterContainsNode) {
            TmfFilterContainsNode node = (TmfFilterContainsNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint) + ' ' + node.getNodeName() + (node.getValue() != null ? " \"" + node.getValue() + "\"" : "");
        } else if (element instanceof TmfFilterEqualsNode) {
            TmfFilterEqualsNode node = (TmfFilterEqualsNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint) + ' ' + node.getNodeName() + (node.getValue() != null ? " \"" + node.getValue() + "\"" : "");
        } else if (element instanceof TmfFilterMatchesNode) {
            TmfFilterMatchesNode node = (TmfFilterMatchesNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint) + ' ' + node.getNodeName() + (node.getRegex() != null ? " \"" + node.getRegex() + "\"" : "");
        } else if (element instanceof TmfFilterCompareNode) {
            TmfFilterCompareNode node = (TmfFilterCompareNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint) + (node.getResult() < 0 ? " <" : (node.getResult() > 0 ? " >" : " =")) + (node.getType() == TmfFilterCompareNode.Type.ALPHA ? " \"" : (node.getType() == TmfFilterCompareNode.Type.TIMESTAMP ? " [" : Character.valueOf(' '))) + (node.hasValidValue() ? node.getValue() : Messages.FilterTreeLabelProvider_ValueHint) + (node.getType() == TmfFilterCompareNode.Type.ALPHA ? Character.valueOf('\"') : (node.getType() == TmfFilterCompareNode.Type.TIMESTAMP ? Character.valueOf(']') : ""));
        }
        return label;
    }
}

