/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;

public class CpuUsageXYViewer
extends TmfCommonXLineChartViewer {
    private KernelCpuUsageAnalysis fModule = null;
    private final Map<String, double[]> fYValues = new LinkedHashMap<String, double[]>();
    private static final double RESOLUTION = 0.4;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private long fSelectedThread = -1L;

    public CpuUsageXYViewer(Composite parent) {
        super(parent, Messages.CpuUsageXYViewer_Title, Messages.CpuUsageXYViewer_TimeXAxis, Messages.CpuUsageXYViewer_CpuYAxis);
        this.setResolution(0.4);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            this.fModule = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
            if (this.fModule == null) {
                return;
            }
            this.fModule.schedule();
        }
    }

    private static double[] zeroFill(int nb) {
        double[] arr = new double[nb];
        Arrays.fill(arr, 0.0);
        return arr;
    }

    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        try {
            if (this.getTrace() == null || this.fModule == null) {
                return;
            }
            this.fModule.waitForInitialization();
            ITmfStateSystem ss = this.fModule.getStateSystem();
            if (ss == null) {
                return;
            }
            double[] xvalues = CpuUsageXYViewer.getXAxis((long)start, (long)end, (int)nb);
            if (xvalues.length == 0) {
                return;
            }
            this.setXAxis(xvalues);
            boolean complete = false;
            long currentEnd = start;
            while (!complete && currentEnd < end) {
                if (monitor.isCanceled()) {
                    return;
                }
                long traceStart = this.getStartTime();
                long traceEnd = this.getEndTime();
                long offset = this.getTimeOffset();
                long selectedThread = this.fSelectedThread;
                complete = ss.waitUntilBuilt(500L);
                currentEnd = ss.getCurrentEndTime();
                Map cpuUsageMap = this.fModule.getCpuUsageInRange(Math.max(start, traceStart), Math.min(end, traceEnd));
                HashMap<String, String> totalEntries = new HashMap<String, String>();
                this.fYValues.clear();
                this.fYValues.put(Messages.CpuUsageXYViewer_Total, CpuUsageXYViewer.zeroFill(xvalues.length));
                String stringSelectedThread = Long.toString(selectedThread);
                if (selectedThread != -1L) {
                    this.fYValues.put(stringSelectedThread, CpuUsageXYViewer.zeroFill(xvalues.length));
                }
                for (Map.Entry entry : cpuUsageMap.entrySet()) {
                    String[] strings;
                    if ((Long)entry.getValue() == 0L || !((String)entry.getKey()).startsWith("total") || (strings = ((String)entry.getKey()).split("/", 2)).length <= 1 || strings[1].equals("0")) continue;
                    totalEntries.put(strings[1], (String)entry.getKey());
                }
                double prevX = xvalues[0] - 1.0;
                long prevTime = (long)prevX + offset;
                prevTime = Math.max(traceStart, prevTime);
                prevTime = Math.min(traceEnd, prevTime);
                int i = 0;
                while (i < xvalues.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    long totalCpu = 0L;
                    double x = xvalues[i];
                    long time = (long)x + offset;
                    time = Math.max(traceStart, time);
                    if ((time = Math.min(traceEnd, time)) == prevTime) {
                        prevTime = time - 1L;
                    }
                    cpuUsageMap = this.fModule.getCpuUsageInRange(prevTime, time);
                    for (Map.Entry entry : totalEntries.entrySet()) {
                        Long cpuEntry = (Long)cpuUsageMap.get(entry.getValue());
                        cpuEntry = cpuEntry != null ? cpuEntry : 0L;
                        totalCpu += cpuEntry.longValue();
                        if (!((String)entry.getKey()).equals(stringSelectedThread)) continue;
                        this.fYValues.get(entry.getKey())[i] = (double)cpuEntry.longValue() / (double)(time - prevTime) * 100.0;
                    }
                    this.fYValues.get((Object)Messages.CpuUsageXYViewer_Total)[i] = (double)totalCpu / (double)(time - prevTime) * 100.0;
                    prevTime = time;
                    ++i;
                }
                for (Map.Entry<String, double[]> entry : this.fYValues.entrySet()) {
                    this.setSeries(entry.getKey(), entry.getValue());
                }
                if (monitor.isCanceled()) {
                    return;
                }
                this.updateDisplay();
            }
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error updating the data of the CPU usage view", e);
        }
    }

    public void setSelectedThread(long tid) {
        this.cancelUpdate();
        this.deleteSeries(Long.toString(this.fSelectedThread));
        this.fSelectedThread = tid;
        this.updateContent();
    }
}

