/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RefreshHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelection selection = part.getSite().getSelectionProvider().getSelection();
        if (selection instanceof TreeSelection) {
            TmfProjectModelElement folder;
            TreeSelection treeSelection = (TreeSelection)selection;
            Object element = treeSelection.getFirstElement();
            IFolder resource = null;
            if (element instanceof TmfTraceFolder) {
                folder = (TmfTraceFolder)element;
                resource = ((TmfTraceFolder)folder).getResource();
            } else if (element instanceof TmfExperimentFolder) {
                folder = (TmfExperimentFolder)element;
                resource = ((TmfExperimentFolder)folder).getResource();
            } else if (element instanceof TmfExperimentElement) {
                folder = (TmfExperimentElement)element;
                resource = ((TmfExperimentElement)folder).getResource();
            }
            try {
                if (resource != null) {
                    resource.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error refreshing projects", e);
            }
        }
        return null;
    }
}

