/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.events.columns;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

@NonNullByDefault
public class TmfEventTableColumn {
    private final ITmfEventAspect fAspect;

    public TmfEventTableColumn(ITmfEventAspect aspect) {
        this.fAspect = aspect;
    }

    public String getHeaderName() {
        return this.fAspect.getName();
    }

    @Nullable
    public String getHeaderTooltip() {
        return this.fAspect.getHelpText();
    }

    public String getItemString(ITmfEvent event) {
        return NonNullUtils.nullToEmptyString((Object)this.fAspect.resolve(event));
    }

    public ITmfEventAspect getEventAspect() {
        return this.fAspect;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fAspect.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventTableColumn)) {
            return false;
        }
        TmfEventTableColumn other = (TmfEventTableColumn)obj;
        return this.fAspect.equals(other.fAspect);
    }
}

