/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource resource) {
        return Resources.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Resources.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return Status.OK_STATUS;
    }

    public static IStatus makeCommittable(IResource resource, Object context) {
        return Resources.makeCommittable(new IResource[]{resource}, context);
    }

    public static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1 && Resources.isReadOnly(resource)) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        if (readOnlyFiles.size() == 0) {
            return Status.OK_STATUS;
        }
        Map oldTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map newTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        Iterator iter = oldTimeStamps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue().equals(newTimeStamps.get(entry.getKey()))) continue;
            modified = Resources.addModified(modified, (IFile)entry.getKey());
        }
        if (modified != null) {
            return modified;
        }
        return Status.OK_STATUS;
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        Status entry = new Status(4, RefactoringCorePlugin.getPluginId(), 10002, Messages.format(RefactoringCoreMessages.Resources_fileModified, BasicElementLabels.getPathLabel(file.getFullPath(), false)), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus(RefactoringCorePlugin.getPluginId(), 10002, RefactoringCoreMessages.Resources_modifiedResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, Messages.format(RefactoringCoreMessages.Resources_outOfSync, BasicElementLabels.getPathLabel(resource.getFullPath(), false)), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, RefactoringCoreMessages.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    public static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    static void setReadOnly(IResource resource, boolean readOnly) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return;
        }
        resourceAttributes.setReadOnly(readOnly);
        try {
            resource.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException e) {
            RefactoringCorePlugin.log(e);
        }
    }

    public static boolean containsOnlyNonProjects(IResource[] resources) {
        int types = Resources.getSelectedResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    public static boolean containsOnlyProjects(IResource[] resources) {
        int types = Resources.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private static int getSelectedResourceTypes(IResource[] resources) {
        int types = 0;
        int i = 0;
        while (i < resources.length) {
            types |= resources[i].getType();
            ++i;
        }
        return types;
    }
}

