/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public final class RenameResourceRefactoringContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_INPUT = "input";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_UPDATE_REFERENCES = "updateReferences";

    public Map retrieveArgumentMap(RefactoringDescriptor descriptor) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (descriptor instanceof RenameResourceDescriptor) {
            RenameResourceDescriptor resourceDescriptor = (RenameResourceDescriptor)descriptor;
            map.put(ATTRIBUTE_INPUT, ResourceProcessors.resourcePathToHandle(descriptor.getProject(), resourceDescriptor.getResourcePath()));
            map.put(ATTRIBUTE_NAME, resourceDescriptor.getNewName());
            map.put(ATTRIBUTE_UPDATE_REFERENCES, resourceDescriptor.isUpdateReferences() ? "true" : "false");
            return map;
        }
        return null;
    }

    public RefactoringDescriptor createDescriptor() {
        return new RenameResourceDescriptor();
    }

    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        String pathString = (String)arguments.get(ATTRIBUTE_INPUT);
        String newName = (String)arguments.get(ATTRIBUTE_NAME);
        boolean updateReferences = "true".equals(arguments.get(ATTRIBUTE_UPDATE_REFERENCES));
        if (pathString != null && newName != null) {
            IPath path = ResourceProcessors.handleToResourcePath(project, pathString);
            RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setNewName(newName);
            descriptor.setResourcePath(path);
            descriptor.setUpdateReferences(updateReferences);
            return descriptor;
        }
        throw new IllegalArgumentException("Can not restore RenameResourceDescriptor from map");
    }
}

