/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTArraySubscriptExpression
extends ASTNode
implements IASTArraySubscriptExpression,
IASTAmbiguityParent {
    private IASTExpression array;
    private IASTExpression subscript;

    public CASTArraySubscriptExpression() {
    }

    public CASTArraySubscriptExpression(IASTExpression array, IASTExpression subscript) {
        this.setArrayExpression(array);
        this.setSubscriptExpression(subscript);
    }

    @Override
    public CASTArraySubscriptExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTArraySubscriptExpression copy(IASTNode.CopyStyle style) {
        CASTArraySubscriptExpression copy = new CASTArraySubscriptExpression();
        copy.setArrayExpression(this.array == null ? null : this.array.copy(style));
        copy.setSubscriptExpression(this.subscript == null ? null : this.subscript.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getArrayExpression() {
        return this.array;
    }

    @Override
    public void setArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.array = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
    }

    @Override
    public IASTExpression getSubscriptExpression() {
        return this.subscript;
    }

    @Override
    public void setSubscriptExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.subscript = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT);
        }
    }

    @Override
    public IASTInitializerClause getArgument() {
        return this.getSubscriptExpression();
    }

    @Override
    public void setArgument(IASTInitializerClause expression) {
        if (expression instanceof IASTExpression) {
            this.setSubscriptExpression((IASTExpression)expression);
        } else {
            this.setSubscriptExpression(null);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.array != null && !this.array.accept(action)) {
            return false;
        }
        if (this.subscript != null && !this.subscript.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.array) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.array = (IASTExpression)other;
        }
        if (child == this.subscript) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscript = (IASTExpression)other;
        }
    }

    @Override
    public IType getExpressionType() {
        IType t = this.getArrayExpression().getExpressionType();
        if ((t = CVisitor.unwrapTypedefs(t)) instanceof IPointerType) {
            return ((IPointerType)t).getType();
        }
        if (t instanceof IArrayType) {
            return ((IArrayType)t).getType();
        }
        return t;
    }

    @Override
    public boolean isLValue() {
        return true;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.LVALUE;
    }
}

