/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.Messages;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Database {
    public static final int INT_SIZE = 4;
    public static final int CHUNK_SIZE = 4096;
    public static final int OFFSET_IN_CHUNK_MASK = 4095;
    public static final int BLOCK_HEADER_SIZE = 2;
    public static final int BLOCK_SIZE_DELTA_BITS = 3;
    public static final int BLOCK_SIZE_DELTA = 8;
    public static final int MIN_BLOCK_DELTAS = 2;
    public static final int MAX_BLOCK_DELTAS = 512;
    public static final int MAX_MALLOC_SIZE = 4094;
    public static final int PTR_SIZE = 4;
    public static final int TYPE_SIZE = 6;
    public static final int VALUE_SIZE = 5;
    public static final int EVALUATION_SIZE = 6;
    public static final int ARGUMENT_SIZE = 6;
    public static final long MAX_DB_SIZE = 0x800000000L;
    public static final int VERSION_OFFSET = 0;
    public static final int DATA_AREA = 2048;
    private static final int BLOCK_PREV_OFFSET = 2;
    private static final int BLOCK_NEXT_OFFSET = 6;
    private final File fLocation;
    private final boolean fReadOnly;
    private RandomAccessFile fFile;
    private boolean fExclusiveLock;
    private boolean fLocked;
    private boolean fIsMarkedIncomplete;
    private int fVersion;
    private final Chunk fHeaderChunk;
    private Chunk[] fChunks;
    private int fChunksUsed;
    private int fChunksAllocated;
    private ChunkCache fCache;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;

    public Database(File location, ChunkCache cache, int version, boolean openReadOnly) throws CoreException {
        try {
            this.fLocation = location;
            this.fReadOnly = openReadOnly;
            this.fCache = cache;
            this.openFile();
            int nChunksOnDisk = (int)(this.fFile.length() / 4096L);
            this.fHeaderChunk = new Chunk(this, 0);
            this.fHeaderChunk.fLocked = true;
            if (nChunksOnDisk <= 0) {
                this.fVersion = version;
                this.fChunks = new Chunk[1];
                this.fChunksUsed = this.fChunksAllocated = this.fChunks.length;
            } else {
                this.fHeaderChunk.read();
                this.fVersion = this.fHeaderChunk.getInt(0L);
                this.fChunks = new Chunk[nChunksOnDisk];
                this.fChunksUsed = this.fChunksAllocated = nChunksOnDisk;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private void openFile() throws FileNotFoundException {
        this.fFile = new RandomAccessFile(this.fLocation, this.fReadOnly ? "r" : "rw");
    }

    void read(ByteBuffer buf, long position) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().read(buf, position);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    void write(ByteBuffer buf, long position) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().write(buf, position);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    private void reopen(ClosedChannelException e, int attempt) throws ClosedChannelException, FileNotFoundException {
        if (e instanceof ClosedByInterruptException || attempt >= 20) {
            throw e;
        }
        this.openFile();
    }

    public void transferTo(FileChannel target) throws IOException {
        assert (this.fLocked);
        FileChannel from = this.fFile.getChannel();
        long nRead = 0L;
        long position = 0L;
        long size = from.size();
        while (position < size) {
            nRead = from.transferTo(position, 65536L, target);
            if (nRead == 0L) break;
            position += nRead;
        }
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void setVersion(int version) throws CoreException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putInt(0L, version);
        this.fVersion = version;
    }

    public void clear(int version) throws CoreException {
        assert (this.fExclusiveLock);
        this.removeChunksFromCache();
        this.fVersion = version;
        this.fHeaderChunk.clear(0L, 4096);
        this.fChunks = new Chunk[1];
        this.fChunksUsed = this.fChunksAllocated = this.fChunks.length;
        try {
            this.fHeaderChunk.flush();
            this.fFile.getChannel().truncate(4096L);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        this.freed = 0L;
        this.malloced = 0L;
        long setasideChunks = Long.getLong("org.eclipse.cdt.core.parser.pdom.dense.recptr.setaside.chunks", 0L);
        if (setasideChunks != 0L) {
            this.setVersion(this.getVersion());
            this.createNewChunks((int)setasideChunks);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null) {
                    this.fCache.remove(chunk);
                    this.fChunks[i] = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(long offset) throws CoreException {
        if (offset < 4096L) {
            return this.fHeaderChunk;
        }
        long long_index = offset / 4096L;
        assert (long_index < Integer.MAX_VALUE);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            Chunk chunk;
            assert (this.fLocked);
            int index = (int)long_index;
            if (index < 0 || index >= this.fChunks.length) {
                this.databaseCorruptionDetected();
            }
            if ((chunk = this.fChunks[index]) == null) {
                ++this.cacheMisses;
                chunk = this.fChunks[index] = new Chunk(this, index);
                chunk.read();
            } else {
                ++this.cacheHits;
            }
            this.fCache.add(chunk, this.fExclusiveLock);
            return chunk;
        }
    }

    private void databaseCorruptionDetected() throws CoreException {
        String msg = MessageFormat.format((String)Messages.getString("Database.CorruptedDatabase"), (Object[])new Object[]{this.fLocation.getName()});
        throw new CoreException((IStatus)new DBStatus(msg));
    }

    public long malloc(int datasize) throws CoreException {
        Chunk chunk;
        assert (this.fExclusiveLock);
        assert (datasize >= 0 && datasize <= 4094);
        int needDeltas = (datasize + 2 + 8 - 1) / 8;
        if (needDeltas < 2) {
            needDeltas = 2;
        }
        long freeblock = 0L;
        int useDeltas = needDeltas;
        while (useDeltas <= 512) {
            freeblock = this.getFirstBlock(useDeltas * 8);
            if (freeblock != 0L) break;
            ++useDeltas;
        }
        if (freeblock == 0L) {
            freeblock = this.createNewChunk();
            useDeltas = 512;
            chunk = this.getChunk(freeblock);
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, useDeltas * 8, freeblock);
        }
        int unusedDeltas = useDeltas - needDeltas;
        if (unusedDeltas >= 2) {
            this.addBlock(chunk, unusedDeltas * 8, freeblock + (long)(needDeltas * 8));
            useDeltas = needDeltas;
        }
        int usedSize = useDeltas * 8;
        chunk.putShort(freeblock, (short)(-usedSize));
        chunk.clear(freeblock + 2L, usedSize - 2);
        this.malloced += (long)usedSize;
        return freeblock + 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNewChunk() throws CoreException {
        assert (this.fExclusiveLock);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int newChunkIndex = this.fChunksUsed;
            Chunk chunk = new Chunk(this, newChunkIndex);
            chunk.fDirty = true;
            if (newChunkIndex >= this.fChunksAllocated) {
                int increment = Math.max(1024, this.fChunksAllocated / 20);
                Chunk[] newchunks = new Chunk[this.fChunksAllocated + increment];
                System.arraycopy(this.fChunks, 0, newchunks, 0, this.fChunksAllocated);
                this.fChunks = newchunks;
                this.fChunksAllocated += increment;
            }
            ++this.fChunksUsed;
            this.fChunks[newChunkIndex] = chunk;
            this.fCache.add(chunk, true);
            long address = (long)newChunkIndex * 4096L;
            if (address >= 0x800000000L) {
                Object[] bindings = new Object[]{this.getLocation().getAbsolutePath(), 0x800000000L};
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 4, NLS.bind((String)CCorePlugin.getResourceString("pdom.DatabaseTooLarge"), (Object[])bindings), null));
            }
            return address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNewChunks(int numChunks) throws CoreException {
        assert (this.fExclusiveLock);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int oldLen = this.fChunks.length;
            Chunk[] newchunks = new Chunk[oldLen + numChunks];
            System.arraycopy(this.fChunks, 0, newchunks, 0, oldLen);
            int i = oldLen;
            while (i < oldLen + numChunks) {
                newchunks[i] = null;
                ++i;
            }
            Chunk chunk = new Chunk(this, oldLen + numChunks - 1);
            chunk.fDirty = true;
            newchunks[oldLen + numChunks - 1] = chunk;
            this.fChunks = newchunks;
            this.fCache.add(chunk, true);
            this.fChunksAllocated = oldLen + numChunks;
            this.fChunksUsed = oldLen + numChunks;
            return (long)(oldLen + numChunks - 1) * 4096L;
        }
    }

    private long getFirstBlock(int blocksize) throws CoreException {
        assert (this.fLocked);
        return this.fHeaderChunk.getFreeRecPtr((blocksize / 8 - 2 + 1) * 4);
    }

    private void setFirstBlock(int blocksize, long block) throws CoreException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putFreeRecPtr((blocksize / 8 - 2 + 1) * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, long block) throws CoreException {
        assert (this.fExclusiveLock);
        long prevblock = chunk.getFreeRecPtr(block + 2L);
        long nextblock = chunk.getFreeRecPtr(block + 6L);
        if (prevblock != 0L) {
            this.putFreeRecPtr(prevblock + 6L, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0L) {
            this.putFreeRecPtr(nextblock + 2L, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, long block) throws CoreException {
        assert (this.fExclusiveLock);
        chunk.putShort(block, (short)blocksize);
        long prevfirst = this.getFirstBlock(blocksize);
        chunk.putFreeRecPtr(block + 2L, 0L);
        chunk.putFreeRecPtr(block + 6L, prevfirst);
        if (prevfirst != 0L) {
            this.putFreeRecPtr(prevfirst + 2L, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(long offset) throws CoreException {
        assert (this.fExclusiveLock);
        long block = offset - 2L;
        Chunk chunk = this.getChunk(block);
        short blocksize = -chunk.getShort(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already freed record " + offset, (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(long offset, byte value) throws CoreException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(long offset) throws CoreException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(long offset, int value) throws CoreException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(long offset) throws CoreException {
        return this.getChunk(offset).getInt(offset);
    }

    public void putRecPtr(long offset, long value) throws CoreException {
        this.getChunk(offset).putRecPtr(offset, value);
    }

    public long getRecPtr(long offset) throws CoreException {
        return this.getChunk(offset).getRecPtr(offset);
    }

    private void putFreeRecPtr(long offset, long value) throws CoreException {
        this.getChunk(offset).putFreeRecPtr(offset, value);
    }

    private long getFreeRecPtr(long offset) throws CoreException {
        return this.getChunk(offset).getFreeRecPtr(offset);
    }

    public void put3ByteUnsignedInt(long offset, int value) throws CoreException {
        this.getChunk(offset).put3ByteUnsignedInt(offset, value);
    }

    public int get3ByteUnsignedInt(long offset) throws CoreException {
        return this.getChunk(offset).get3ByteUnsignedInt(offset);
    }

    public void putShort(long offset, short value) throws CoreException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(long offset) throws CoreException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(long offset, long value) throws CoreException {
        this.getChunk(offset).putLong(offset, value);
    }

    public long getLong(long offset) throws CoreException {
        return this.getChunk(offset).getLong(offset);
    }

    public void putChar(long offset, char value) throws CoreException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(long offset) throws CoreException {
        return this.getChunk(offset).getChar(offset);
    }

    public void clearBytes(long offset, int byteCount) throws CoreException {
        this.getChunk(offset).clear(offset, byteCount);
    }

    public void putBytes(long offset, byte[] data, int len) throws CoreException {
        this.getChunk(offset).put(offset, data, len);
    }

    public void putBytes(long offset, byte[] data, int dataPos, int len) throws CoreException {
        this.getChunk(offset).put(offset, data, dataPos, len);
    }

    public void getBytes(long offset, byte[] data) throws CoreException {
        this.getChunk(offset).get(offset, data);
    }

    public void getBytes(long offset, byte[] data, int dataPos, int len) throws CoreException {
        this.getChunk(offset).get(offset, data, dataPos, len);
    }

    public IString newString(String string) throws CoreException {
        return this.newString(string.toCharArray());
    }

    public IString newString(char[] chars) throws CoreException {
        int len = chars.length;
        boolean useBytes = this.useBytes(chars);
        int bytelen = useBytes ? len : 2 * len;
        if (bytelen > 4090) {
            return new LongString(this, chars, useBytes);
        }
        return new ShortString(this, chars, useBytes);
    }

    private boolean useBytes(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((c & 0xFF00) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IString getString(long offset) throws CoreException {
        int bytelen;
        int l = this.getInt(offset);
        int n = bytelen = l < 0 ? -l : 2 * l;
        if (bytelen > 4090) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public void reportFreeBlocks() throws CoreException {
        System.out.println("Allocated size: " + this.fChunksUsed * 4096);
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + ((long)(this.fChunksUsed * 4096) - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            long block = this.getFirstBlock(bs);
            while (block != 0L) {
                ++count;
                block = this.getFreeRecPtr(block + 6L);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 8;
        }
    }

    public void close() throws CoreException {
        assert (this.fExclusiveLock);
        this.flush();
        this.removeChunksFromCache();
        this.fHeaderChunk.clear(0L, 4096);
        this.fHeaderChunk.fDirty = false;
        this.fChunks = new Chunk[1];
        this.fChunksUsed = this.fChunksAllocated = this.fChunks.length;
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.fLocation;
    }

    void releaseChunk(Chunk chunk) {
        if (!chunk.fLocked) {
            this.fChunks[chunk.fSequenceNumber] = null;
        }
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setExclusiveLock() {
        this.fExclusiveLock = true;
        this.fLocked = true;
    }

    public void setLocked(boolean val) {
        this.fLocked = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveUpExclusiveLock(boolean flush) throws CoreException {
        if (this.fExclusiveLock) {
            try {
                ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    int i = 1;
                    while (i < this.fChunksUsed) {
                        Chunk chunk = this.fChunks[i];
                        if (chunk != null) {
                            if (chunk.fCacheIndex < 0) {
                                if (chunk.fDirty) {
                                    dirtyChunks.add(chunk);
                                } else {
                                    chunk.fLocked = false;
                                    this.fChunks[i] = null;
                                }
                            } else if (chunk.fLocked) {
                                if (chunk.fDirty) {
                                    if (flush) {
                                        dirtyChunks.add(chunk);
                                    }
                                } else {
                                    chunk.fLocked = false;
                                }
                            } else assert (!chunk.fDirty);
                        }
                        ++i;
                    }
                }
                this.flushAndUnlockChunks(dirtyChunks, flush);
            }
            finally {
                this.fExclusiveLock = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CoreException {
        assert (this.fLocked);
        if (this.fExclusiveLock) {
            try {
                this.giveUpExclusiveLock(true);
            }
            finally {
                this.setExclusiveLock();
            }
            return;
        }
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunksUsed) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null && chunk.fDirty) {
                    dirtyChunks.add(chunk);
                }
                ++i;
            }
        }
        this.flushAndUnlockChunks(dirtyChunks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAndUnlockChunks(ArrayList<Chunk> dirtyChunks, boolean isComplete) throws CoreException {
        assert (!Thread.holdsLock(this.fCache));
        Chunk chunk = this.fHeaderChunk;
        synchronized (chunk) {
            boolean haveDirtyChunks;
            boolean bl = haveDirtyChunks = !dirtyChunks.isEmpty();
            if (haveDirtyChunks || this.fHeaderChunk.fDirty) {
                this.markFileIncomplete();
            }
            if (haveDirtyChunks) {
                for (Chunk chunk2 : dirtyChunks) {
                    if (!chunk2.fDirty) continue;
                    chunk2.flush();
                }
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    for (Chunk chunk3 : dirtyChunks) {
                        chunk3.fLocked = false;
                        if (chunk3.fCacheIndex >= 0) continue;
                        this.fChunks[chunk3.fSequenceNumber] = null;
                    }
                }
            }
            if (isComplete && (this.fHeaderChunk.fDirty || this.fIsMarkedIncomplete)) {
                this.fHeaderChunk.putInt(0L, this.fVersion);
                this.fHeaderChunk.flush();
                this.fIsMarkedIncomplete = false;
            }
        }
    }

    private void markFileIncomplete() throws CoreException {
        if (!this.fIsMarkedIncomplete) {
            this.fIsMarkedIncomplete = true;
            try {
                ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
                this.fFile.getChannel().write(buf, 0L);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new DBStatus(e));
            }
        }
    }

    public void resetCacheCounters() {
        this.cacheMisses = 0L;
        this.cacheHits = 0L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getSizeBytes() {
        try {
            return this.fFile.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static void putRecPtr(long value, byte[] buffer, int idx) {
        int denseValue = value == 0L ? 0 : Chunk.compressFreeRecPtr(value - 2L);
        Chunk.putInt(denseValue, buffer, idx);
    }

    public static long getRecPtr(byte[] buffer, int idx) {
        int value = Chunk.getInt(buffer, idx);
        long address = Chunk.expandToFreeRecPtr(value);
        return address != 0L ? address + 2L : address;
    }
}

