/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;

public class PDOMCAnnotation {
    public static final int AUTO_OFFSET = 0;
    public static final int EXTERN_OFFSET = 1;
    public static final int INLINE_OFFSET = 2;
    public static final int REGISTER_OFFSET = 3;
    public static final int STATIC_OFFSET = 4;
    public static final int VARARGS_OFFSET = 5;
    public static final int NO_RETURN = 6;
    public static final int CONST_OFFSET = 0;
    public static final int VOLATILE_OFFSET = 1;

    public static byte encodeAnnotation(IBinding binding) {
        byte modifiers = 0;
        if (binding instanceof IVariable) {
            IVariable variable = (IVariable)binding;
            modifiers = (byte)(modifiers | (variable.isAuto() ? 1 : 0) << 0);
            modifiers = (byte)(modifiers | (variable.isExtern() ? 1 : 0) << 1);
            modifiers = (byte)(modifiers | (variable.isRegister() ? 1 : 0) << 3);
            modifiers = (byte)(modifiers | (variable.isStatic() ? 1 : 0) << 4);
        }
        if (binding instanceof IFunction) {
            IFunction function = (IFunction)binding;
            modifiers = (byte)(modifiers | (function.isAuto() ? 1 : 0) << 0);
            modifiers = (byte)(modifiers | (function.isExtern() ? 1 : 0) << 1);
            modifiers = (byte)(modifiers | (function.isRegister() ? 1 : 0) << 3);
            modifiers = (byte)(modifiers | (ASTInternal.isStatic(function, false) ? 1 : 0) << 4);
            modifiers = (byte)(modifiers | (function.isInline() ? 1 : 0) << 2);
            modifiers = (byte)(modifiers | (function.takesVarArgs() ? 1 : 0) << 5);
            modifiers = (byte)(modifiers | (function.isNoReturn() ? 1 : 0) << 6);
        }
        return modifiers;
    }

    public static byte encodeCVQualifiers(ICPPFunctionType type) {
        byte modifiers = 0;
        modifiers = (byte)(modifiers | (type.isConst() ? 1 : 0) << 0);
        modifiers = (byte)(modifiers | (type.isVolatile() ? 1 : 0) << 1);
        return modifiers;
    }
}

