/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model;

public enum TraceChannelOutputType {
    SPLICE("splice()", "SPLICE"),
    MMAP("mmap()", "MMAP"),
    UNKNOWN("unknown", "unknown");

    private final String fInName;
    private final String fInMiName;

    private TraceChannelOutputType(String name, String miName) {
        this.fInName = name;
        this.fInMiName = miName;
    }

    public String getInName() {
        return this.fInName;
    }

    public String getInMiName() {
        return this.fInMiName;
    }

    public static TraceChannelOutputType valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        TraceChannelOutputType[] traceChannelOutputTypeArray = TraceChannelOutputType.values();
        int n = traceChannelOutputTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isEqual;
            TraceChannelOutputType tdType = traceChannelOutputTypeArray[n2];
            boolean bl = isEqual = tdType.getInName().equalsIgnoreCase(name) || tdType.getInMiName().equalsIgnoreCase(name);
            if (isEqual) {
                return tdType;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

