/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

class MarkerResourceUtil {
    static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];

    MarkerResourceUtil() {
    }

    static Set<IResource> computeResources(IResource[] selectedResources, Collection<MarkerFieldFilterGroup> enabledFilters, boolean andFilters) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        Set<IResource> resourceSet = andFilters ? MarkerResourceUtil.getResourcesFiltersAnded(enabledFilters, selectedResources, root) : MarkerResourceUtil.getResourcesFiltersOred(enabledFilters, selectedResources, root);
        return MarkerResourceUtil.trim2ParentResources(root, resourceSet);
    }

    static Set<IResource> trim2ParentResources(IWorkspaceRoot root, Set<IResource> resourceSet) {
        if (resourceSet.isEmpty() || resourceSet.size() == 1) {
            return resourceSet;
        }
        if (resourceSet.contains(root)) {
            resourceSet.clear();
            resourceSet.add((IResource)root);
            return resourceSet;
        }
        Object[] clones = resourceSet.toArray();
        int i = 0;
        while (i < clones.length) {
            IResource resource = (IResource)clones[i];
            Iterator<IResource> iterator = resourceSet.iterator();
            while (iterator.hasNext()) {
                IResource resToRemove = iterator.next();
                if (resToRemove.equals((Object)root)) {
                    resourceSet.clear();
                    resourceSet.add((IResource)root);
                    return resourceSet;
                }
                if (resource.equals((Object)resToRemove) || !resource.getFullPath().isPrefixOf(resToRemove.getFullPath())) continue;
                iterator.remove();
            }
            ++i;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesFiltersOred(Collection<MarkerFieldFilterGroup> enabledFilters, IResource[] selectedResources, IWorkspaceRoot root) {
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        for (MarkerFieldFilterGroup group : enabledFilters) {
            Set<IResource> set = MarkerResourceUtil.getResourcesForFilter(group, selectedResources, root);
            resourceSet.addAll(set);
            if (!resourceSet.contains(root)) continue;
            set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesFiltersAnded(Collection<MarkerFieldFilterGroup> enabledFilters, IResource[] selectedResources, IWorkspaceRoot root) {
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        Iterator<MarkerFieldFilterGroup> filtersIterator = enabledFilters.iterator();
        HashSet<IResource> removeMain = new HashSet<IResource>();
        while (filtersIterator.hasNext()) {
            MarkerFieldFilterGroup group = filtersIterator.next();
            Set<IResource> set = MarkerResourceUtil.getResourcesForFilter(group, selectedResources, root);
            if (resourceSet.isEmpty()) {
                resourceSet.addAll(set);
                continue;
            }
            Iterator resIterator = resourceSet.iterator();
            while (resIterator.hasNext()) {
                boolean remove = true;
                IResource mainRes = (IResource)resIterator.next();
                Iterator<IResource> iterator = set.iterator();
                while (iterator.hasNext() && remove) {
                    IResource grpRes = iterator.next();
                    boolean bl = remove = !grpRes.equals((Object)mainRes);
                    if (remove && grpRes.getFullPath().isPrefixOf(mainRes.getFullPath())) {
                        remove = false;
                        continue;
                    }
                    if (!remove || !mainRes.getFullPath().isPrefixOf(grpRes.getFullPath())) continue;
                    remove = false;
                    removeMain.add(mainRes);
                }
                if (!remove) continue;
                resIterator.remove();
            }
            Iterator<IResource> iterator = set.iterator();
            while (iterator.hasNext()) {
                boolean remove = true;
                IResource grpRes = iterator.next();
                resIterator = resourceSet.iterator();
                while (resIterator.hasNext() && remove) {
                    IResource mainRes = (IResource)resIterator.next();
                    boolean bl = remove = !grpRes.equals((Object)mainRes);
                    if (!remove || !mainRes.getFullPath().isPrefixOf(grpRes.getFullPath())) continue;
                    remove = false;
                }
                if (!remove) continue;
                iterator.remove();
            }
            resourceSet.addAll(set);
            resourceSet.removeAll(removeMain);
            removeMain.clear();
            if (!resourceSet.isEmpty()) continue;
            return resourceSet;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesForFilter(MarkerFieldFilterGroup group, IResource[] selectedResources, IWorkspaceRoot root) {
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        switch (group.getScope()) {
            case 0: {
                resourceSet.add((IResource)root);
                break;
            }
            case 1: 
            case 2: {
                int i = 0;
                while (i < selectedResources.length) {
                    resourceSet.add(selectedResources[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                IProject[] resources = MarkerResourceUtil.getProjects(selectedResources);
                int i = 0;
                while (i < resources.length) {
                    resourceSet.add((IResource)resources[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                group.refresh();
                IResource[] resources = group.getResourcesInWorkingSet();
                int i = 0;
                while (i < resources.length) {
                    resourceSet.add(resources[i]);
                    ++i;
                }
                break;
            }
        }
        return resourceSet;
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        Collection<IProject> projects = MarkerResourceUtil.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection<IProject> getProjectsAsCollection(Object[] elements) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int idx = 0;
        while (idx < elements.length) {
            if (elements[idx] instanceof IResource) {
                projects.add(((IResource)elements[idx]).getProject());
            } else {
                IProject[] mappingProjects = ((ResourceMapping)elements[idx]).getProjects();
                int i = 0;
                while (i < mappingProjects.length) {
                    projects.add(mappingProjects[i]);
                    ++i;
                }
            }
            ++idx;
        }
        return projects;
    }

    static void addResources(Collection<IResource> resourceCollection, ResourceMapping resourceMapping) {
        try {
            ResourceTraversal[] traversals = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                IResource[] result = traversal.getResources();
                int j = 0;
                while (j < result.length) {
                    resourceCollection.add(result[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    static Object adapt2ResourceElement(Object object) {
        ITaskListResourceAdapter adapter;
        IResource resource = null;
        if (object instanceof IAdaptable && (adapter = (ITaskListResourceAdapter)Util.getAdapter((Object)object, ITaskListResourceAdapter.class)) != null) {
            resource = adapter.getAffectedResource((IAdaptable)object);
        }
        if (resource == null) {
            resource = (IResource)Util.getAdapter((Object)object, IResource.class);
        }
        if (resource == null) {
            resource = (IResource)Util.getAdapter((Object)object, IFile.class);
        }
        if (resource == null) {
            ResourceMapping mapping = (ResourceMapping)Util.getAdapter((Object)object, ResourceMapping.class);
            if (mapping != null) {
                return mapping;
            }
        } else {
            return resource;
        }
        return null;
    }

    static String[] getAllSubTypesIds(String[] typeIds) {
        HashSet<MarkerType> set = MarkerResourceUtil.getAllSubTypes(typeIds);
        return MarkerResourceUtil.toTypeStrings(set);
    }

    static HashSet<MarkerType> getAllSubTypes(String[] typeIds) {
        HashSet<MarkerType> set = new HashSet<MarkerType>();
        MarkerTypesModel typesModel = MarkerTypesModel.getInstance();
        int i = 0;
        while (i < typeIds.length) {
            MarkerType type = typesModel.getType(typeIds[i]);
            set.add(type);
            MarkerType[] subs = type.getAllSubTypes();
            int j = 0;
            while (j < subs.length) {
                set.add(subs[j]);
                ++j;
            }
            ++i;
        }
        return set;
    }

    static String[] getMutuallyExclusiveSupersIds(String[] typeIds) {
        HashSet<MarkerType> set = MarkerResourceUtil.getMutuallyExclusiveSupers(typeIds);
        return MarkerResourceUtil.toTypeStrings(set);
    }

    static HashSet<MarkerType> getMutuallyExclusiveSupers(String[] typeIds) {
        MarkerType type;
        HashSet<MarkerType> set = new HashSet<MarkerType>();
        MarkerTypesModel typesModel = MarkerTypesModel.getInstance();
        int i = 0;
        while (i < typeIds.length) {
            type = typesModel.getType(typeIds[i]);
            set.add(type);
            ++i;
        }
        i = 0;
        while (i < typeIds.length) {
            type = typesModel.getType(typeIds[i]);
            MarkerType[] subs = type.getAllSubTypes();
            HashSet<MarkerType> subsOnly = new HashSet<MarkerType>(Arrays.asList(subs));
            subsOnly.remove(type);
            set.removeAll(subsOnly);
            ++i;
        }
        return set;
    }

    private static String[] toTypeStrings(Collection<MarkerType> collection) {
        HashSet<String> ids = new HashSet<String>();
        for (MarkerType type : collection) {
            ids.add(type.getId());
        }
        return ids.toArray(new String[ids.size()]);
    }
}

