/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.trace;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;

public final class BtfEventAspects {
    @NonNull
    private static final Iterable<ITmfEventAspect> BTF_ASPECTS = (Iterable)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)ITmfEventAspect.BaseAspects.TIMESTAMP, (Object)new BtfSourceAspect(), (Object)new TmfContentFieldAspect(BtfColumnNames.SOURCE_INSTANCE.toString(), new String[]{BtfColumnNames.SOURCE_INSTANCE.toString()}), (Object)ITmfEventAspect.BaseAspects.EVENT_TYPE, (Object)new BtfTargetAspect(), (Object)new TmfContentFieldAspect(BtfColumnNames.TARGET_INSTANCE.toString(), new String[]{BtfColumnNames.TARGET_INSTANCE.toString()}), (Object)new TmfContentFieldAspect(BtfColumnNames.EVENT.toString(), new String[]{BtfColumnNames.EVENT.toString()}), (Object)new TmfContentFieldAspect(BtfColumnNames.NOTES.toString(), new String[]{BtfColumnNames.NOTES.toString()})));

    private BtfEventAspects() {
    }

    @NonNull
    public static Iterable<ITmfEventAspect> getAspects() {
        return BTF_ASPECTS;
    }

    private static class BtfSourceAspect
    implements ITmfEventAspect {
        private BtfSourceAspect() {
        }

        public String getName() {
            return BtfColumnNames.SOURCE.toString();
        }

        public String getHelpText() {
            return "";
        }

        public String resolve(ITmfEvent event) {
            if (!(event instanceof BtfEvent)) {
                return "";
            }
            String ret = ((BtfEvent)event).getSource();
            return ret == null ? "" : ret;
        }
    }

    private static class BtfTargetAspect
    implements ITmfEventAspect {
        private BtfTargetAspect() {
        }

        public String getName() {
            return BtfColumnNames.TARGET.toString();
        }

        public String getHelpText() {
            return "";
        }

        public String resolve(ITmfEvent event) {
            if (!(event instanceof BtfEvent)) {
                return "";
            }
            String ret = ((BtfEvent)event).getTarget();
            return ret == null ? "" : ret;
        }
    }
}

