/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelMergeOperation;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageCompareEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class ModelParticipantMergeOperation
extends ModelMergeOperation {
    public static final int REQUEST_PREVIEW = 1024;
    private ModelSynchronizeParticipant participant;
    private boolean ownsParticipant = true;
    private boolean sentToSyncView;
    private static final Object PARTICIPANT_MERGE_FAMILY = new Object();
    static /* synthetic */ Class class$0;

    protected ModelParticipantMergeOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part, manager);
    }

    protected void initializeContext(IProgressMonitor monitor) throws CoreException {
        if (this.participant == null) {
            this.participant = this.createParticipant();
            if (this.isPreviewRequested() && !this.isPreviewInDialog()) {
                this.handlePreviewRequest();
                this.sentToSyncView = true;
            }
            this.participant.getContext().refresh(this.getScope().getTraversals(), 1, monitor);
            if (!this.sentToSyncView) {
                try {
                    Job.getJobManager().join((Object)this.participant.getContext(), monitor);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            super.execute(monitor);
        }
        finally {
            if (this.ownsParticipant && this.participant != null) {
                this.participant.dispose();
            }
        }
    }

    protected void executeMerge(IProgressMonitor monitor) throws CoreException {
        if (!this.sentToSyncView) {
            super.executeMerge(monitor);
        }
    }

    protected void handlePreviewRequest() {
        WorkbenchJob job = new WorkbenchJob(this.getJobName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ModelParticipantMergeOperation.this.isPreviewInDialog()) {
                    CompareConfiguration cc = new CompareConfiguration();
                    ISynchronizePageConfiguration pageConfiguration = ModelParticipantMergeOperation.this.participant.createPageConfiguration();
                    if (pageConfiguration.getComparisonType() == "three-way") {
                        pageConfiguration.setSupportedModes(9);
                        pageConfiguration.setMode(1);
                    }
                    ParticipantPageCompareEditorInput input = new ParticipantPageCompareEditorInput(cc, pageConfiguration, ModelParticipantMergeOperation.this.participant);
                    CompareUI.openCompareDialog((CompareEditorInput)input);
                } else {
                    Object adapted;
                    ISynchronizeManager mgr = TeamUI.getSynchronizeManager();
                    ISynchronizeView view = mgr.showSynchronizeViewInActivePage();
                    mgr.addSynchronizeParticipants(new ISynchronizeParticipant[]{ModelParticipantMergeOperation.this.participant});
                    view.display(ModelParticipantMergeOperation.this.participant);
                    IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapted = iWorkbenchPartSite.getAdapter((Class)clazz)) instanceof IWorkbenchSiteProgressService) {
                        IWorkbenchSiteProgressService siteProgress = (IWorkbenchSiteProgressService)adapted;
                        siteProgress.showBusyForFamily(PARTICIPANT_MERGE_FAMILY);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (TeamUI.getSynchronizeManager().get(ModelParticipantMergeOperation.this.participant.getId(), ModelParticipantMergeOperation.this.participant.getSecondaryId()) == null) {
                    ModelParticipantMergeOperation.this.participant.dispose();
                }
            }
        });
        this.ownsParticipant = false;
        job.schedule();
    }

    public boolean belongsTo(Object family) {
        if (family == PARTICIPANT_MERGE_FAMILY) {
            return true;
        }
        if (this.participant != null && this.participant == family) {
            return true;
        }
        return super.belongsTo(family);
    }

    protected boolean isPreviewInDialog() {
        return true;
    }

    protected ISynchronizationContext getContext() {
        if (this.participant != null) {
            return this.participant.getContext();
        }
        return null;
    }

    protected String getPreviewRequestMessage() {
        if (!this.isPreviewRequested()) {
            return TeamUIMessages.ResourceMappingMergeOperation_4;
        }
        return super.getPreviewRequestMessage();
    }

    protected ModelSynchronizeParticipant createParticipant() {
        return ModelSynchronizeParticipant.createParticipant(this.createMergeContext(), this.getJobName());
    }

    protected abstract SynchronizationContext createMergeContext();
}

