/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceSaveableComparison;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.services.IDisposable;

public abstract class SaveableCompareEditorInput
extends CompareEditorInput
implements ISaveablesSource {
    private ICompareInputChangeListener compareInputChangeListener;
    private final IWorkbenchPage page;
    private final ListenerList inputChangeListeners = new ListenerList(1);
    private Saveable saveable;
    private IPropertyListener propertyListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static ITypedElement createFileElement(IFile file) {
        return new LocalResourceTypedElement((IResource)file);
    }

    private static ITypedElement getFileElement(ICompareInput input, CompareEditorInput editorInput) {
        if (input.getLeft() instanceof LocalResourceTypedElement) {
            return input.getLeft();
        }
        if (editorInput instanceof CompareFileRevisionEditorInput) {
            return ((CompareFileRevisionEditorInput)editorInput).getLocalElement();
        }
        return null;
    }

    public SaveableCompareEditorInput(CompareConfiguration configuration, IWorkbenchPage page) {
        super(configuration);
        this.page = page;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.compareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                if (source == SaveableCompareEditorInput.this.getCompareResult()) {
                    boolean closed = false;
                    if (source.getKind() == 0) {
                        closed = SaveableCompareEditorInput.this.closeEditor(true);
                    }
                    if (!closed) {
                        SaveableCompareEditorInput.this.propogateInputChange();
                    }
                }
            }
        };
        this.getCompareInput().addCompareInputChangeListener(this.compareInputChangeListener);
        if (this.getSaveable() instanceof SaveableComparison) {
            SaveableComparison scm = (SaveableComparison)this.saveable;
            this.propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        SaveableCompareEditorInput.this.setDirty(SaveableCompareEditorInput.this.saveable.isDirty());
                    }
                }
            };
            scm.addPropertyListener(this.propertyListener);
        }
        this.setDirty(this.saveable.isDirty());
    }

    private ISaveablesLifecycleListener getSaveablesLifecycleListener(IWorkbenchPart part) {
        ISaveablesLifecycleListener listener;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listener = (ISaveablesLifecycleListener)Utils.getAdapter(part, clazz)) == null) {
            IWorkbenchPartSite iWorkbenchPartSite = part.getSite();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            listener = (ISaveablesLifecycleListener)iWorkbenchPartSite.getService((Class)clazz2);
        }
        return listener;
    }

    protected void handleDispose() {
        super.handleDispose();
        ICompareInput compareInput = this.getCompareInput();
        if (compareInput != null) {
            compareInput.removeCompareInputChangeListener(this.compareInputChangeListener);
        }
        this.compareInputChangeListener = null;
        if (this.saveable instanceof SaveableComparison && this.propertyListener != null) {
            SaveableComparison scm = (SaveableComparison)this.saveable;
            scm.removePropertyListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.saveable instanceof LocalResourceSaveableComparison) {
            LocalResourceSaveableComparison rsc = (LocalResourceSaveableComparison)this.saveable;
            rsc.dispose();
        }
        if (this.getCompareResult() instanceof IDisposable) {
            ((IDisposable)this.getCompareResult()).dispose();
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.prepareCompareInput(monitor);
        if (input != null) {
            this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{input.getName()}));
        }
        return input;
    }

    protected abstract ICompareInput prepareCompareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    protected final ICompareInput getCompareInput() {
        return (ICompareInput)this.getCompareResult();
    }

    protected abstract void fireInputChange();

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        final IWorkbenchPage page = this.getPage();
        if (page == null) {
            return false;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Shell shell = page.getWorkbenchWindow().getShell();
                if (shell == null) {
                    return;
                }
                IEditorPart part = page.findEditor((IEditorInput)SaveableCompareEditorInput.this);
                SaveableCompareEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Shell shell = page.getWorkbenchWindow().getShell();
            if (shell == null) {
                return false;
            }
            Display display = shell.getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    private IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    void propogateInputChange() {
        if (!this.inputChangeListeners.isEmpty()) {
            Object[] allListeners = this.inputChangeListeners.getListeners();
            int i = 0;
            while (i < allListeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)allListeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)SaveableCompareEditorInput.this.getCompareResult());
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    protected Saveable getSaveable() {
        if (this.saveable == null) {
            this.saveable = this.createSaveable();
        }
        return this.saveable;
    }

    protected Saveable createSaveable() {
        Object compareResult = this.getCompareResult();
        Assert.isNotNull((Object)compareResult, (String)"This method cannot be called until after prepareInput is called");
        return new InternalResourceSaveableComparison((ICompareInput)compareResult, this);
    }

    public Saveable[] getActiveSaveables() {
        if (this.getCompareResult() == null) {
            return new Saveable[0];
        }
        return new Saveable[]{this.getSaveable()};
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }

    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.add((Object)listener);
        } else {
            super.addCompareInputChangeListener(input, listener);
        }
    }

    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.remove((Object)listener);
        } else {
            super.removeCompareInputChangeListener(input, listener);
        }
    }

    public Object getAdapter(Class adapter) {
        IResource resource;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && (resource = Utils.getResource(this.getCompareResult())) instanceof IFile) {
            return resource;
        }
        return super.getAdapter(adapter);
    }

    public Image getTitleImage() {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Image image = reg.get("eview16/synch_synch.gif");
        if (image == null) {
            image = this.getImageDescriptor().createImage();
            reg.put("eview16/synch_synch.gif", image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier && this.saveable instanceof IPropertyChangeListener) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            final IPropertyChangeListener pcl = (IPropertyChangeListener)this.saveable;
            dsp.addPropertyChangeListener(pcl);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(pcl);
                }
            });
        }
        return newViewer;
    }

    public boolean canRunAsJob() {
        return true;
    }

    public boolean isDirty() {
        if (this.saveable != null) {
            return this.saveable.isDirty();
        }
        return super.isDirty();
    }

    public void registerContextMenu(MenuManager menu, final ISelectionProvider selectionProvider) {
        super.registerContextMenu(menu, selectionProvider);
        final Saveable saveable = this.getSaveable();
        if (saveable instanceof LocalResourceSaveableComparison) {
            final ITypedElement element = SaveableCompareEditorInput.getFileElement(this.getCompareInput(), this);
            menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SaveablesCompareEditorInput.handleMenuAboutToShow(manager, SaveableCompareEditorInput.this.getContainer(), saveable, element, selectionProvider);
                }
            });
        }
    }

    private class InternalResourceSaveableComparison
    extends LocalResourceSaveableComparison
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        private LocalResourceTypedElement lrte;
        private boolean connected = false;

        public InternalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput) {
            super(input, editorInput, SaveableCompareEditorInput.getFileElement(input, editorInput));
            ITypedElement element = SaveableCompareEditorInput.getFileElement(input, editorInput);
            if (element instanceof LocalResourceTypedElement) {
                this.lrte = (LocalResourceTypedElement)element;
                if (this.lrte.isConnected()) {
                    this.registerSaveable(true);
                } else {
                    this.lrte.setSharedDocumentListener(this);
                }
            }
        }

        protected void fireInputChange() {
            SaveableCompareEditorInput.this.fireInputChange();
        }

        public void dispose() {
            super.dispose();
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        public void handleDocumentConnected() {
            if (this.connected) {
                return;
            }
            this.connected = true;
            this.registerSaveable(false);
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        private void registerSaveable(boolean init) {
            ICompareContainer container = SaveableCompareEditorInput.this.getContainer();
            IWorkbenchPart part = container.getWorkbenchPart();
            if (part != null) {
                ISaveablesLifecycleListener lifecycleListener = SaveableCompareEditorInput.this.getSaveablesLifecycleListener(part);
                if (!init) {
                    lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 3, new Saveable[]{this}, false));
                }
                this.initializeHashing();
                lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 1, new Saveable[]{this}, false));
            }
        }

        public void handleDocumentDeleted() {
        }

        public void handleDocumentDisconnected() {
        }

        public void handleDocumentFlushed() {
        }

        public void handleDocumentSaved() {
        }
    }
}

