/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.commands;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.commands.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.commands.TmfHandlerUtil;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        String filePath;
        File parentFile;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ISelection menuSelection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell);
        fd.setText(Messages.OpenFileHandler_SelectTraceFile);
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.ui");
        String lastLocation = defaultPreferences.get("PREF_LAST_OPEN_FILE_LOCATION", null);
        if (lastLocation != null && !lastLocation.isEmpty() && (parentFile = new File(lastLocation).getParentFile()) != null && parentFile.exists()) {
            fd.setFilterPath(parentFile.toString());
        }
        if ((filePath = fd.open()) == null) {
            return null;
        }
        try {
            TmfTraceFolder destinationFolder;
            if (menuSelection != null && currentSelection instanceof IStructuredSelection) {
                destinationFolder = TmfHandlerUtil.getTraceFolderFromSelection(currentSelection);
            } else {
                IProject project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
                TmfProjectElement projectElement = TmfProjectRegistry.getProject(project, true);
                destinationFolder = projectElement.getTracesFolder();
            }
            TmfOpenTraceHelper.openTraceFromPath(destinationFolder, filePath, shell);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.ui").put("PREF_LAST_OPEN_FILE_LOCATION", filePath);
        return null;
    }
}

