/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class ProcessorBasedRefactoring
extends Refactoring {
    private static final String PERF_CHECK_CONDITIONS = "org.eclipse.ltk.core.refactoring/perf/participants/checkConditions";
    private static final String PERF_CREATE_CHANGES = "org.eclipse.ltk.core.refactoring/perf/participants/createChanges";
    private RefactoringProcessor fProcessor;
    private List fParticipants;
    private List fPreChangeParticipants;
    private Map fTextChangeMap;
    private static final List EMPTY_PARTICIPANTS = Collections.EMPTY_LIST;
    static /* synthetic */ Class class$0;

    protected ProcessorBasedRefactoring() {
    }

    public ProcessorBasedRefactoring(RefactoringProcessor processor) {
        this.setProcessor(processor);
    }

    public RefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public void setProcessor(RefactoringProcessor processor) {
        processor.setRefactoring(this);
        this.fProcessor = processor;
    }

    public final boolean isApplicable() throws CoreException {
        return this.getProcessor().isApplicable();
    }

    public String getName() {
        return this.getProcessor().getProcessorName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 10);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_initial_conditions);
        result.merge(this.getProcessor().checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 8)));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        CheckConditionsContext context = this.createCheckConditionsContext();
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_final_conditions);
        result.merge(this.getProcessor().checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 5), context));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        SharableParticipants sharableParticipants = new SharableParticipants();
        RefactoringParticipant[] loadedParticipants = this.getProcessor().loadParticipants(result, sharableParticipants);
        if (loadedParticipants == null || loadedParticipants.length == 0) {
            this.fParticipants = EMPTY_PARTICIPANTS;
        } else {
            this.fParticipants = new ArrayList();
            int i = 0;
            while (i < loadedParticipants.length) {
                this.fParticipants.add(loadedParticipants[i]);
                ++i;
            }
        }
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        SubProgressMonitor sm = new SubProgressMonitor(pm, 2);
        sm.beginTask("", this.fParticipants.size());
        Iterator iter = this.fParticipants.iterator();
        while (iter.hasNext() && !result.hasFatalError()) {
            RefactoringParticipant participant = (RefactoringParticipant)((Object)iter.next());
            PerformanceStats stats = PerformanceStats.getStats((String)PERF_CHECK_CONDITIONS, (Object)(String.valueOf(this.getName()) + ", " + participant.getName()));
            stats.startRun();
            try {
                result.merge(participant.checkConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sm, 1), context));
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                RefactoringCorePlugin.log(e);
                result.merge(RefactoringStatus.createErrorStatus(Messages.format(RefactoringCoreMessages.ProcessorBasedRefactoring_check_condition_participant_failed, participant.getName())));
                iter.remove();
            }
            stats.endRun();
            if (!sm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        sm.done();
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", this.fParticipants.size() + 3);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_create_change);
        Change processorChange = this.getProcessor().createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fTextChangeMap = new HashMap();
        this.addToTextChangeMap(processorChange);
        ArrayList<Change> changes = new ArrayList<Change>();
        ArrayList<Change> preChanges = new ArrayList<Change>();
        HashMap<Change, RefactoringParticipant> participantMap = new HashMap<Change, RefactoringParticipant>();
        Iterator iter = this.fParticipants.iterator();
        while (iter.hasNext()) {
            RefactoringParticipant participant = (RefactoringParticipant)((Object)iter.next());
            try {
                PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_CHANGES, (Object)(String.valueOf(this.getName()) + ", " + participant.getName()));
                stats.startRun();
                Change preChange = participant.createPreChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Change change = participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                stats.endRun();
                if (preChange != null) {
                    if (this.fPreChangeParticipants == null) {
                        this.fPreChangeParticipants = new ArrayList();
                    }
                    this.fPreChangeParticipants.add(participant);
                    preChanges.add(preChange);
                    participantMap.put(preChange, participant);
                    this.addToTextChangeMap(preChange);
                }
                if (change != null) {
                    changes.add(change);
                    participantMap.put(change, participant);
                    this.addToTextChangeMap(change);
                }
            }
            catch (CoreException e) {
                ProcessorBasedRefactoring.disableParticipant(participant, e);
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                ProcessorBasedRefactoring.disableParticipant(participant, e);
                throw e;
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.fTextChangeMap = null;
        Change postChange = this.getProcessor().postCreateChange(changes.toArray(new Change[changes.size()]), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ProcessorChange result = new ProcessorChange(this.getName());
        result.addAll(preChanges.toArray(new Change[preChanges.size()]));
        result.add(processorChange);
        result.addAll(changes.toArray(new Change[changes.size()]));
        result.setParticipantMap(participantMap);
        result.setPreChangeParticipants(this.fPreChangeParticipants);
        if (postChange != null) {
            result.add(postChange);
        }
        return result;
    }

    public TextChange getTextChange(Object element) {
        if (this.fTextChangeMap == null) {
            return null;
        }
        return (TextChange)this.fTextChangeMap.get(element);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        if (clazz.isInstance((Object)this.getProcessor())) {
            return this.getProcessor();
        }
        return super.getAdapter(clazz);
    }

    public String toString() {
        return this.getName();
    }

    private CheckConditionsContext createCheckConditionsContext() throws CoreException {
        CheckConditionsContext result = new CheckConditionsContext();
        result.add(new ValidateEditChecker(this.getValidationContext()));
        result.add(new ResourceChangeChecker());
        return result;
    }

    private static void disableParticipant(RefactoringParticipant participant, Throwable e) {
        ParticipantDescriptor descriptor = participant.getDescriptor();
        descriptor.disable();
        RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
    }

    private void addToTextChangeMap(Change change) {
        block8: {
            block7: {
                if (!(change instanceof TextChange)) break block7;
                Object element = ((TextChange)change).getModifiedElement();
                if (element != null) {
                    this.fTextChangeMap.put(element, change);
                }
                if (!(change instanceof TextFileChange)) break block8;
                Class<?> clazz = change.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.TextFileChange");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) break block8;
                IFile file = ((TextFileChange)change).getFile();
                this.fTextChangeMap.put(file, change);
                break block8;
            }
            if (change instanceof CompositeChange) {
                Change[] children = ((CompositeChange)change).getChildren();
                int i = 0;
                while (i < children.length) {
                    this.addToTextChangeMap(children[i]);
                    ++i;
                }
            }
        }
    }

    private static class ProcessorChange
    extends CompositeChange {
        private Map fParticipantMap;
        private List fPreChangeParticipants;

        public ProcessorChange(String name) {
            super(name);
            this.markAsSynthetic();
        }

        public void setParticipantMap(Map map) {
            this.fParticipantMap = map;
        }

        public void setPreChangeParticipants(List list) {
            this.fPreChangeParticipants = list;
        }

        protected void internalHandleException(Change change, Throwable e) {
            if (e instanceof OperationCanceledException) {
                return;
            }
            RefactoringParticipant participant = (RefactoringParticipant)((Object)this.fParticipantMap.get(change));
            if (participant != null) {
                ProcessorBasedRefactoring.disableParticipant(participant, e);
            } else if (this.fPreChangeParticipants != null) {
                Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10008, RefactoringCoreMessages.ProcessorBasedRefactoring_prechange_participants_removed, e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                Iterator it = this.fPreChangeParticipants.iterator();
                while (it.hasNext()) {
                    participant = (RefactoringParticipant)((Object)it.next());
                    ProcessorBasedRefactoring.disableParticipant(participant, null);
                }
            }
        }

        protected boolean internalContinueOnCancel() {
            return true;
        }

        protected boolean internalProcessOnCancel(Change change) {
            RefactoringParticipant participant = (RefactoringParticipant)((Object)this.fParticipantMap.get(change));
            if (participant == null) {
                return false;
            }
            return participant.getDescriptor().processOnCancel();
        }
    }
}

