/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceSessionPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceSessionComponent
extends TraceControlComponent {
    public static final String TRACE_SESSION_ICON_FILE_INACTIVE = "icons/obj16/session_inactive.gif";
    public static final String TRACE_SESSION_ICON_FILE_ACTIVE = "icons/obj16/session_active.gif";
    public static final String TRACE_SESSION_ICON_FILE_DESTROYED = "icons/obj16/session_destroyed.gif";
    private ISessionInfo fSessionInfo = null;
    private boolean fIsDestroyed = false;
    private Image fActiveImage = null;
    private Image fDestroyedImage = null;

    public TraceSessionComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_SESSION_ICON_FILE_INACTIVE);
        this.setToolTip(Messages.TraceControl_SessionDisplayName);
        this.fSessionInfo = new SessionInfo(name);
        this.fActiveImage = Activator.getDefault().loadIcon(TRACE_SESSION_ICON_FILE_ACTIVE);
        this.fDestroyedImage = Activator.getDefault().loadIcon(TRACE_SESSION_ICON_FILE_DESTROYED);
    }

    public TraceSessionComponent(ISessionInfo sessionInfo, ITraceControlComponent parent) {
        this(sessionInfo.getName(), parent);
        this.copyLiveInfo(sessionInfo);
    }

    private void copyLiveInfo(ISessionInfo sessionInfo) {
        if (sessionInfo.getLivePort() != null) {
            this.fSessionInfo.setLivePort(sessionInfo.getLivePort());
        }
        if (sessionInfo.getLiveUrl() != null) {
            this.fSessionInfo.setLiveUrl(sessionInfo.getLiveUrl());
        }
        if (!this.getTargetNode().isVersionSupported("2.5.0")) {
            this.fSessionInfo.setLive(sessionInfo.isLive());
        }
    }

    @Override
    public Image getImage() {
        if (this.fIsDestroyed) {
            return this.fDestroyedImage;
        }
        if (this.fSessionInfo.getSessionState() == TraceSessionState.INACTIVE) {
            return super.getImage();
        }
        return this.fActiveImage;
    }

    public boolean isDestroyed() {
        return this.fIsDestroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.fIsDestroyed = destroyed;
    }

    public TraceSessionState getSessionState() {
        return this.fSessionInfo.getSessionState();
    }

    public void setSessionState(TraceSessionState state) {
        this.fSessionInfo.setSessionState(state);
    }

    public void setSessionState(String stateName) {
        this.fSessionInfo.setSessionState(stateName);
    }

    public String getSessionPath() {
        return this.fSessionInfo.getSessionPath();
    }

    public void setSessionPath(String sessionPath) {
        this.fSessionInfo.setSessionPath(sessionPath);
    }

    public boolean isStreamedTrace() {
        return this.fSessionInfo.isStreamedTrace();
    }

    public void setIsStreamedTrace(boolean isStreamedTrace) {
        this.fSessionInfo.setStreamedTrace(isStreamedTrace);
    }

    public boolean isSnapshotSession() {
        return this.fSessionInfo.isSnapshotSession();
    }

    public ISnapshotInfo getSnapshotInfo() {
        return this.fSessionInfo.getSnapshotInfo();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new TraceSessionPropertySource(this);
        }
        return null;
    }

    public TraceDomainComponent[] getDomains() {
        List<ITraceControlComponent> sessions = this.getChildren(TraceDomainComponent.class);
        return sessions.toArray(new TraceDomainComponent[sessions.size()]);
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceSessionGroup)this.getParent()).getTargetNode();
    }

    public boolean hasKernelProvider() {
        List<ITraceControlComponent> providerGroups = this.getTargetNode().getChildren(TraceProviderGroup.class);
        return !providerGroups.isEmpty() ? ((TraceProviderGroup)providerGroups.get(0)).hasKernelProvider() : false;
    }

    public boolean isEventFilteringSupported(boolean isKernel) {
        return ((TargetNodeComponent)this.getParent().getParent()).isEventFilteringSupported(isKernel);
    }

    public boolean isSnapshotSupported() {
        return ((TargetNodeComponent)this.getParent().getParent()).isSnapshotSupported();
    }

    public void getConfigurationFromNode(IProgressMonitor monitor) throws ExecutionException {
        this.removeAllChildren();
        ISessionInfo newInfo = this.getControlService().getSession(this.getName(), monitor);
        if (newInfo != null) {
            ISessionInfo oldSessionInfo = this.fSessionInfo;
            this.fSessionInfo = newInfo;
            this.copyLiveInfo(oldSessionInfo);
            IDomainInfo[] domains = this.fSessionInfo.getDomains();
            int i = 0;
            while (i < domains.length) {
                TraceDomainComponent domainComponent = new TraceDomainComponent(domains[i].getName(), this);
                this.addChild(domainComponent);
                domainComponent.setDomainInfo(domains[i]);
                ++i;
            }
        }
    }

    public void startSession(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().startSession(this.getName(), monitor);
    }

    public void stopSession(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().stopSession(this.getName(), monitor);
    }

    public void enableChannels(List<String> channelNames, IChannelInfo info, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableChannels(this.getName(), channelNames, isKernel, info, monitor);
    }

    public void enableEvents(List<String> eventNames, boolean isKernel, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableEvents(this.getName(), null, eventNames, isKernel, filterExpression, monitor);
    }

    public void enableSyscalls(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableSyscalls(this.getName(), null, monitor);
    }

    public void enableProbe(String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableProbe(this.getName(), null, eventName, isFunction, probe, monitor);
    }

    public void enableLogLevel(String eventName, LogLevelType logLevelType, TraceLogLevel level, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableLogLevel(this.getName(), null, eventName, logLevelType, level, null, monitor);
    }

    public List<String> getContextList(IProgressMonitor monitor) throws ExecutionException {
        return this.getControlService().getContextList(monitor);
    }

    public void recordSnapshot(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().recordSnapshot(this.getName(), monitor);
    }

    public void saveSession(String session, String outputPath, boolean isForce, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().saveSession(session, outputPath, isForce, monitor);
    }

    public boolean isLiveTrace() {
        return this.fSessionInfo.isLive();
    }

    public String getLiveUrl() {
        return this.fSessionInfo.getLiveUrl();
    }

    public Integer getLivePort() {
        return this.fSessionInfo.getLivePort();
    }
}

