/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences;

import java.io.File;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.lttng2.control.core.LttngProfileManager;
import org.eclipse.ui.PlatformUI;

public class LTTngProfileViewer {
    public static CheckboxTreeViewer createLTTngProfileViewer(Composite parent, int style) {
        CheckboxTreeViewer fFolderViewer = new CheckboxTreeViewer(parent, style);
        fFolderViewer.setContentProvider((IContentProvider)new ProfileContentProvider());
        fFolderViewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        fFolderViewer.setInput((Object)LTTngProfileViewer.getViewerInput());
        return fFolderViewer;
    }

    public static File[] getViewerInput() {
        return LttngProfileManager.getProfiles();
    }

    public static class ProfileContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object o) {
            File store = (File)o;
            if (store.isDirectory()) {
                return store.listFiles();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof File) {
                return ((File)element).getParent();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof File[]) {
                return (File[])inputElement;
            }
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            return ((File)element).isDirectory();
        }
    }

    public static class ProfileLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((File)element).getName();
        }

        public Image getImage(Object element) {
            if (((File)element).isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }
}

