/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;

public class EventDeclaration
implements IEventDeclaration {
    private String fName;
    private StructDeclaration fContext = null;
    private StructDeclaration fFields = null;
    private CTFStream fStream = null;
    private long fLogLevel;
    private final Map<String, String> fCustomAttributes = new HashMap<String, String>();
    private int fId = -2;

    public EventDefinition createDefinition(CTFStreamInputReader streamInputReader, ICompositeDefinition eventHeaderDef, @NonNull BitBuffer input, long prevTimestamp) throws CTFException {
        StructDeclaration streamEventContextDecl = streamInputReader.getStreamEventContextDecl();
        StructDefinition streamEventContext = streamEventContextDecl != null ? streamEventContextDecl.createDefinition((IDefinitionScope)this.fStream.getTrace(), ILexicalScope.STREAM_EVENT_CONTEXT, input) : null;
        StructDefinition packetContext = streamInputReader.getPacketReader().getCurrentPacketEventHeader();
        StructDefinition eventContext = this.fContext != null ? this.fContext.createFieldDefinition(eventHeaderDef, this.fStream.getTrace(), ILexicalScope.CONTEXT, input) : null;
        StructDefinition eventPayload = this.fFields != null ? this.fFields.createFieldDefinition(eventHeaderDef, this.fStream.getTrace(), ILexicalScope.FIELDS, input) : null;
        long timestamp = EventDeclaration.calculateTimestamp(eventHeaderDef, prevTimestamp, eventPayload, eventContext);
        return new EventDefinition(this, streamInputReader, timestamp, eventHeaderDef, streamEventContext, eventContext, packetContext, eventPayload);
    }

    private static long calculateTimestamp(@Nullable ICompositeDefinition eventHeaderDef, long prevTimestamp, StructDefinition eventPayload, StructDefinition eventContext) throws CTFIOException {
        long timestamp = 0L;
        Definition def = null;
        if (eventHeaderDef instanceof EventHeaderDefinition) {
            EventHeaderDefinition eventHeaderDefinition = (EventHeaderDefinition)eventHeaderDef;
            timestamp = EventDeclaration.calculateTimestamp(eventHeaderDefinition.getTimestamp(), eventHeaderDefinition.getTimestampLength(), prevTimestamp);
        } else if (eventHeaderDef instanceof StructDefinition) {
            StructDefinition structDefinition = (StructDefinition)eventHeaderDef;
            def = structDefinition.lookupDefinition("timestamp");
        } else if (eventHeaderDef != null) {
            throw new CTFIOException("Event header def is not a Struct or an Event Header");
        }
        if (def == null && eventPayload != null) {
            def = eventPayload.lookupDefinition("timestamp");
        }
        if (def == null && eventContext != null) {
            def = eventContext.lookupDefinition("timestamp");
        }
        if (def instanceof IntegerDefinition) {
            IntegerDefinition timestampDef = (IntegerDefinition)def;
            timestamp = EventDeclaration.calculateTimestamp(timestampDef, prevTimestamp);
        }
        return timestamp;
    }

    @Override
    public EventDefinition createDefinition(CTFStreamInputReader streamInputReader, @NonNull BitBuffer input, long timestamp) throws CTFException {
        StructDeclaration streamEventContextDecl = streamInputReader.getStreamEventContextDecl();
        StructDefinition streamEventContext = streamEventContextDecl != null ? streamEventContextDecl.createDefinition((IDefinitionScope)this.fStream.getTrace(), ILexicalScope.STREAM_EVENT_CONTEXT, input) : null;
        StructDefinition packetContext = streamInputReader.getPacketReader().getCurrentPacketEventHeader();
        StructDefinition eventContext = this.fContext != null ? this.fContext.createDefinition((IDefinitionScope)this.fStream.getTrace(), ILexicalScope.CONTEXT, input) : null;
        StructDefinition eventPayload = this.fFields != null ? this.fFields.createDefinition((IDefinitionScope)this.fStream.getTrace(), ILexicalScope.FIELDS, input) : null;
        return new EventDefinition(this, streamInputReader, timestamp, streamEventContext, eventContext, packetContext, eventPayload);
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setContext(StructDeclaration context) {
        this.fContext = context;
    }

    public void setFields(StructDeclaration fields) {
        this.fFields = fields;
    }

    @Override
    public StructDeclaration getFields() {
        return this.fFields;
    }

    @Override
    public StructDeclaration getContext() {
        return this.fContext;
    }

    public void setId(long id) {
        if (id < 0L || id > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("id out of range");
        }
        this.fId = (int)id;
    }

    @Override
    public Long getId() {
        return this.fId;
    }

    public int id() {
        return this.fId;
    }

    public void setStream(CTFStream stream) {
        this.fStream = stream;
    }

    @Override
    public CTFStream getStream() {
        return this.fStream;
    }

    public boolean nameIsSet() {
        return this.fName != null;
    }

    public boolean contextIsSet() {
        return this.fContext != null;
    }

    public boolean fieldsIsSet() {
        return this.fFields != null;
    }

    public boolean idIsSet() {
        return (long)this.fId != -2L;
    }

    public boolean streamIsSet() {
        return this.fStream != null;
    }

    @Override
    public long getLogLevel() {
        return this.fLogLevel;
    }

    public void setLogLevel(long level) {
        this.fLogLevel = level;
    }

    @Override
    public Set<String> getCustomAttributes() {
        return this.fCustomAttributes.keySet();
    }

    @Override
    public String getCustomAttribute(String key) {
        return this.fCustomAttributes.get(key);
    }

    public void setCustomAttribute(String key, String value) {
        this.fCustomAttributes.put(key, value);
    }

    private static long calculateTimestamp(IntegerDefinition timestampDef, long lastTimestamp) {
        int len = timestampDef.getDeclaration().getLength();
        long value = timestampDef.getValue();
        return EventDeclaration.calculateTimestamp(value, len, lastTimestamp);
    }

    private static long calculateTimestamp(long value, int len, long prevTimestamp) {
        long lastTimestamp = prevTimestamp;
        if (len == 64) {
            lastTimestamp = value;
            return lastTimestamp;
        }
        long newval = value;
        long majorasbitmask = (1L << len) - 1L;
        if (newval < (lastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        lastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        return lastTimestamp += newval;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDeclaration)) {
            return false;
        }
        EventDeclaration other = (EventDeclaration)obj;
        if (this.fContext == null ? other.fContext != null : !this.fContext.equals(other.fContext)) {
            return false;
        }
        if (this.fFields == null ? other.fFields != null : !this.fFields.equals(other.fFields)) {
            return false;
        }
        if (this.fId != other.fId) {
            return false;
        }
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        if (this.fStream == null ? other.fStream != null : !this.fStream.equals(other.fStream)) {
            return false;
        }
        return this.fCustomAttributes.equals(other.fCustomAttributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fContext == null ? 0 : this.fContext.hashCode());
        result = 31 * result + (this.fFields == null ? 0 : this.fFields.hashCode());
        result = 31 * result + this.fId;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fStream == null ? 0 : this.fStream.hashCode());
        result = 31 * result + this.fCustomAttributes.hashCode();
        return result;
    }
}

