/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.DefaultVariableContextInfo;
import org.eclipse.cdt.internal.core.cdtvariables.EnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.ICoreVariableContextInfo;
import org.eclipse.cdt.internal.core.envvar.BuildSystemEnvironmentSupplier;
import org.eclipse.cdt.internal.core.envvar.ContributedEnvironment;
import org.eclipse.cdt.internal.core.envvar.DefaultEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.EclipseEnvironmentSupplier;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class EnvironmentVariableManager
implements IEnvironmentVariableManager {
    private static final String DELIMITER_WIN32 = ";";
    private static final String DELIMITER_UNIX = ":";
    private static EnvironmentVariableManager fInstance = null;
    public static final UserDefinedEnvironmentSupplier fUserSupplier = new UserDefinedEnvironmentSupplier();
    public static final BuildSystemEnvironmentSupplier fExternalSupplier = new BuildSystemEnvironmentSupplier();
    public static final EclipseEnvironmentSupplier fEclipseSupplier = new EclipseEnvironmentSupplier();
    private ContributedEnvironment fContributedEnvironment = new ContributedEnvironment(this);

    protected EnvironmentVariableManager() {
    }

    public static EnvironmentVariableManager getDefault() {
        if (fInstance == null) {
            fInstance = new EnvironmentVariableManager();
        }
        return fInstance;
    }

    public static EnvVarDescriptor getVariable(String variableName, IEnvironmentContextInfo contextInfo, boolean includeParentLevels) {
        if (contextInfo == null) {
            return null;
        }
        if ((variableName = EnvVarOperationProcessor.normalizeName(variableName)) == null) {
            return null;
        }
        IEnvironmentContextInfo[] infos = EnvironmentVariableManager.getAllContextInfos(contextInfo);
        if (!includeParentLevels) {
            ICoreEnvironmentVariableSupplier[] suppliers = infos[0].getSuppliers();
            boolean bVarFound = false;
            ICoreEnvironmentVariableSupplier[] iCoreEnvironmentVariableSupplierArray = suppliers;
            int n = suppliers.length;
            int n2 = 0;
            while (n2 < n) {
                ICoreEnvironmentVariableSupplier supplier = iCoreEnvironmentVariableSupplierArray[n2];
                if (supplier.getVariable(variableName, infos[0].getContext()) != null) {
                    bVarFound = true;
                    break;
                }
                ++n2;
            }
            if (!bVarFound) {
                return null;
            }
        }
        IEnvironmentVariable variable = null;
        IEnvironmentContextInfo varContextInfo = null;
        int varSupplierNum = -1;
        ICoreEnvironmentVariableSupplier varSupplier = null;
        int i = infos.length - 1;
        while (i >= 0) {
            IEnvironmentContextInfo info = infos[i];
            ICoreEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
            int j = suppliers.length - 1;
            while (j >= 0) {
                ICoreEnvironmentVariableSupplier supplier = suppliers[j];
                IEnvironmentVariable var = supplier.getVariable(variableName, info.getContext());
                if (var != null) {
                    varContextInfo = info;
                    varSupplierNum = j;
                    varSupplier = supplier;
                    variable = variable == null ? var : EnvVarOperationProcessor.performOperation(variable, var);
                }
                --j;
            }
            --i;
        }
        if (variable != null) {
            return new EnvVarDescriptor(variable, varContextInfo, varSupplierNum, varSupplier);
        }
        return null;
    }

    @Override
    public IEnvironmentVariable getVariable(String variableName, ICConfigurationDescription cfg, boolean resolveMacros) {
        if (variableName == null || "".equals(variableName)) {
            return null;
        }
        IEnvironmentContextInfo info = this.getContextInfo(cfg);
        EnvVarDescriptor var = EnvironmentVariableManager.getVariable(variableName, info, true);
        if (var != null && var.getOperation() != 2) {
            return resolveMacros ? this.calculateResolvedVariable(var, info) : var;
        }
        return null;
    }

    IEnvironmentContextInfo getDefaultContextInfo(Object level) {
        DefaultEnvironmentContextInfo info = new DefaultEnvironmentContextInfo(level);
        if (info.getSuppliers() == null) {
            return null;
        }
        return info;
    }

    public IEnvironmentContextInfo getContextInfo(Object level) {
        if (level instanceof ICConfigurationDescription) {
            return this.fContributedEnvironment.appendEnvironment((ICConfigurationDescription)level) ? this.getDefaultContextInfo(level) : this.fContributedEnvironment.getContextInfo(level);
        }
        return this.getDefaultContextInfo(level);
    }

    public static EnvVarCollector getVariables(IEnvironmentContextInfo contextInfo, boolean includeParentLevels) {
        int i;
        if (contextInfo == null) {
            return null;
        }
        IEnvironmentContextInfo[] infos = EnvironmentVariableManager.getAllContextInfos(contextInfo);
        HashSet<String> set = null;
        if (!includeParentLevels) {
            ICoreEnvironmentVariableSupplier[] suppliers = infos[0].getSuppliers();
            set = new HashSet<String>();
            i = 0;
            while (i < suppliers.length) {
                IEnvironmentVariable[] vars = suppliers[i].getVariables(infos[0].getContext());
                if (vars != null) {
                    IEnvironmentVariable[] iEnvironmentVariableArray = vars;
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                        String name = EnvVarOperationProcessor.normalizeName(var.getName());
                        if (name != null) {
                            set.add(name);
                        }
                        ++n2;
                    }
                }
                if (!suppliers[i].appendEnvironment(infos[0].getContext())) break;
                ++i;
            }
            if (set.size() == 0) {
                return new EnvVarCollector();
            }
        }
        EnvVarCollector envVarSet = new EnvVarCollector();
        i = infos.length - 1;
        while (i >= 0) {
            IEnvironmentContextInfo info = infos[i];
            ICoreEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
            int j = suppliers.length - 1;
            while (j >= 0) {
                ICoreEnvironmentVariableSupplier supplier = suppliers[j];
                if (!supplier.appendEnvironment(info.getContext())) {
                    envVarSet.clear();
                }
                IEnvironmentVariable[] vars = null;
                if (set != null) {
                    ArrayList<IEnvironmentVariable> varList = new ArrayList<IEnvironmentVariable>();
                    Iterator iter = set.iterator();
                    while (iter.hasNext()) {
                        IEnvironmentVariable var = supplier.getVariable((String)iter.next(), info.getContext());
                        if (var == null) continue;
                        varList.add(var);
                    }
                    vars = varList.toArray(new IEnvironmentVariable[varList.size()]);
                } else {
                    vars = supplier.getVariables(info.getContext());
                }
                envVarSet.add(vars, info, j, supplier);
                --j;
            }
            --i;
        }
        return envVarSet;
    }

    @Override
    public IEnvironmentVariable[] getVariables(ICConfigurationDescription cfg, boolean resolveMacros) {
        IEnvironmentVariable[] vars;
        IEnvironmentContextInfo info = this.getContextInfo(cfg);
        EnvVarCollector varSet = EnvironmentVariableManager.getVariables(info, true);
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = varSet != null ? varSet.toArray(false) : null;
        if (vars != null) {
            if (!resolveMacros) {
                return vars;
            }
            IEnvironmentVariable[] resolved = new IEnvironmentVariable[vars.length];
            int i = 0;
            while (i < vars.length) {
                resolved[i] = this.calculateResolvedVariable((EnvVarDescriptor)vars[i], info);
                ++i;
            }
            return resolved;
        }
        return new EnvVarDescriptor[0];
    }

    public static IEnvironmentContextInfo[] getAllContextInfos(IEnvironmentContextInfo contextInfo) {
        if (contextInfo == null) {
            return null;
        }
        ArrayList<IEnvironmentContextInfo> list = new ArrayList<IEnvironmentContextInfo>();
        list.add(contextInfo);
        while ((contextInfo = contextInfo.getNext()) != null) {
            list.add(contextInfo);
        }
        return list.toArray(new IEnvironmentContextInfo[list.size()]);
    }

    private boolean isWin32() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows ");
    }

    @Override
    public String getDefaultDelimiter() {
        return this.isWin32() ? DELIMITER_WIN32 : DELIMITER_UNIX;
    }

    @Override
    public boolean isVariableCaseSensitive() {
        return !this.isWin32();
    }

    public ICoreEnvironmentVariableSupplier[] getSuppliers(Object level) {
        IEnvironmentContextInfo info = this.getContextInfo(level);
        if (info != null) {
            return info.getSuppliers();
        }
        return null;
    }

    public boolean checkParentContextRelation(IEnvironmentContextInfo child, IEnvironmentContextInfo parent) {
        if (child == null || parent == null) {
            return false;
        }
        IEnvironmentContextInfo enumInfo = child;
        do {
            if (parent.getContext() != enumInfo.getContext()) continue;
            return true;
        } while ((enumInfo = enumInfo.getNext()) != null);
        return false;
    }

    public IEnvironmentVariable calculateResolvedVariable(EnvVarDescriptor des, IEnvironmentContextInfo info) {
        if (des == null || info == null) {
            return null;
        }
        return this.calculateResolvedVariable(des, this.getVariableSubstitutor(this.getMacroContextInfoForContext(info.getContext()), "", " "));
    }

    public IEnvironmentVariable calculateResolvedVariable(EnvVarDescriptor des, IVariableSubstitutor sub) {
        if (des == null) {
            return null;
        }
        IEnvironmentVariable var = des;
        try {
            if (sub instanceof EnvVarVariableSubstitutor) {
                var = ((EnvVarVariableSubstitutor)sub).resolveVariable(des);
            } else if (des.getOperation() != 2) {
                String name = des.getName();
                var = new EnvironmentVariable(name, sub.resolveToString(name), des.getOperation(), des.getDelimiter());
            }
        }
        catch (CdtVariableException cdtVariableException) {
            // empty catch block
        }
        return var;
    }

    protected int getMacroContextTypeFromContext(Object context) {
        if (context instanceof ICConfigurationDescription) {
            return 3;
        }
        return 5;
    }

    public ICoreVariableContextInfo getMacroContextInfoForContext(Object context) {
        return new DefaultVariableContextInfo(this.getMacroContextTypeFromContext(context), context);
    }

    public IVariableSubstitutor getVariableSubstitutor(IVariableContextInfo info, String inexistentMacroValue, String listDelimiter) {
        return new EnvVarVariableSubstitutor(info, inexistentMacroValue, listDelimiter);
    }

    @Override
    public IContributedEnvironment getContributedEnvironment() {
        return this.fContributedEnvironment;
    }

    public class EnvVarVariableSubstitutor
    extends SupplierBasedCdtVariableSubstitutor {
        private String fDefaultDelimiter;

        public EnvVarVariableSubstitutor(IVariableContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
            super(contextInfo, inexistentMacroValue, listDelimiter, null, inexistentMacroValue);
            this.fDefaultDelimiter = listDelimiter;
        }

        public IEnvironmentVariable resolveVariable(EnvVarDescriptor var) throws CdtVariableException {
            String value;
            if (var == null || (value = var.getValue()) == null || value.length() == 0 || var.getOperation() == 2) {
                return var;
            }
            String listDelimiter = var.getDelimiter();
            if (listDelimiter == null) {
                listDelimiter = this.fDefaultDelimiter;
            }
            this.setListDelimiter(listDelimiter);
            ICdtVariable macro = EnvironmentVariableSupplier.getInstance().createBuildMacro(var);
            IVariableContextInfo varMacroInfo = this.getVarMacroContextInfo(var);
            int varSupplierNum = this.getVarMacroSupplierNum(var, varMacroInfo);
            value = this.resolveToString(new SupplierBasedCdtVariableSubstitutor.MacroDescriptor((SupplierBasedCdtVariableSubstitutor)this, macro, varMacroInfo, varSupplierNum));
            this.removeResolvedMacro(var.getName());
            return new EnvironmentVariable(var.getName(), value, var.getOperation(), var.getDelimiter());
        }

        protected IVariableContextInfo getVarMacroContextInfo(EnvVarDescriptor var) {
            IEnvironmentContextInfo info = var.getContextInfo();
            if (info != null) {
                return EnvironmentVariableManager.this.getMacroContextInfoForContext(info.getContext());
            }
            return null;
        }

        protected int getVarMacroSupplierNum(EnvVarDescriptor var, IVariableContextInfo varMacroInfo) {
            int varSupplierNum = -1;
            ICdtVariableSupplier[] macroSuppliers = varMacroInfo.getSuppliers();
            if (macroSuppliers != null) {
                int i = 0;
                while (i < macroSuppliers.length) {
                    if (macroSuppliers[i] instanceof EnvironmentVariableSupplier) {
                        varSupplierNum = i;
                        break;
                    }
                    ++i;
                }
            }
            return varSupplierNum;
        }
    }
}

