/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.ui;

import java.util.Arrays;
import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class BtfEventPropertySource
extends TmfEventPropertySource {
    private static final String ID_EVENT_EVENT = "event_event";
    private static final String ID_EVENT_TIMESTAMP = "event_timestamp";
    private static final String ID_EVENT_SOURCE = "event_source";
    private static final String ID_EVENT_TYPE = "event_type";
    private static final String ID_EVENT_TARGET = "event_target";
    private static final String ID_EVENT_NOTES = "event_notes";
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor((Object)"event_timestamp", "Timestamp"), new ReadOnlyTextPropertyDescriptor((Object)"event_source", "Source"), new ReadOnlyTextPropertyDescriptor((Object)"event_type", "Type"), new ReadOnlyTextPropertyDescriptor((Object)"event_target", "Target"), new ReadOnlyTextPropertyDescriptor((Object)"event_event", "Event"), new ReadOnlyTextPropertyDescriptor((Object)"event_notes", "Notes")};
    private static final IPropertyDescriptor[] DESCRIPTORS_WITHOUT_NOTES = Arrays.copyOf(DESCRIPTORS, DESCRIPTORS.length - 1);
    private static final String DESCRIPTION = "Description";
    private static final String INSTANCE = "Instance";
    private final BtfEvent fEvent;

    public BtfEventPropertySource(BtfEvent event) {
        super((ITmfEvent)event);
        this.fEvent = event;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fEvent.getContent().getField(new String[]{BtfColumnNames.NOTES.toString()}) == null) {
            return DESCRIPTORS_WITHOUT_NOTES;
        }
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object id) {
        block19: {
            if (!(id instanceof String)) break block19;
            String id2 = (String)id;
            ITmfEventField content = this.fEvent.getContent();
            switch (id2) {
                case "event_source": {
                    String source = this.fEvent.getSource();
                    ITmfEventField sourceInstance = content.getField(new String[]{BtfColumnNames.SOURCE_INSTANCE.toString()});
                    return new EntityPropertySource(source, sourceInstance.getValue().toString());
                }
                case "event_type": {
                    return new TypePropertySource(this.fEvent.getType().getName(), this.fEvent.getEventDescription());
                }
                case "event_target": {
                    String target = this.fEvent.getTarget();
                    ITmfEventField targetInstance = content.getField(new String[]{BtfColumnNames.TARGET_INSTANCE.toString()});
                    return new EntityPropertySource(target, targetInstance.getValue().toString());
                }
                case "event_event": {
                    ITmfEventField event = content.getField(new String[]{BtfColumnNames.EVENT.toString()});
                    return event == null ? null : new EventPropertySource(event);
                }
                case "event_notes": {
                    ITmfEventField notes = content.getField(new String[]{BtfColumnNames.NOTES.toString()});
                    return notes == null ? null : notes.getValue();
                }
            }
        }
        return super.getPropertyValue(id);
    }

    private class EntityPropertySource
    implements IPropertySource {
        private final String fName;
        private final String fInstance;

        public EntityPropertySource(String name, String instance) {
            this.fName = name;
            this.fInstance = instance;
        }

        public Object getEditableValue() {
            return this.fName;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor((Object)BtfEventPropertySource.INSTANCE, BtfEventPropertySource.INSTANCE)};
        }

        public Object getPropertyValue(Object id) {
            if (BtfEventPropertySource.INSTANCE.equals(id)) {
                return this.fInstance;
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    private class EventPropertySource
    implements IPropertySource {
        private final ITmfEventField fEventField;

        public EventPropertySource(ITmfEventField eventField) {
            this.fEventField = eventField;
        }

        public Object getEditableValue() {
            return this.fEventField.getValue();
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor((Object)BtfEventPropertySource.DESCRIPTION, BtfEventPropertySource.DESCRIPTION)};
        }

        public Object getPropertyValue(Object id) {
            if (BtfEventPropertySource.DESCRIPTION.equals(id)) {
                ITmfEventField description = this.fEventField.getField(new String[]{"description"});
                return description == null ? null : description.getValue();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    private class TypePropertySource
    implements IPropertySource {
        private final String fType;
        private final String fDescr;

        public TypePropertySource(String type, String descr) {
            this.fType = type;
            this.fDescr = descr;
        }

        public Object getEditableValue() {
            return this.fType;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor((Object)BtfEventPropertySource.DESCRIPTION, BtfEventPropertySource.DESCRIPTION)};
            return descriptors;
        }

        public Object getPropertyValue(Object id) {
            if (BtfEventPropertySource.DESCRIPTION.equals(id)) {
                return this.fDescr;
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

