/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;

public class TraceProviderGroup
extends TraceControlComponent {
    public static final String TRACE_PROVIDERS_ICON_FILE = "icons/obj16/providers.gif";

    public TraceProviderGroup(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_PROVIDERS_ICON_FILE);
    }

    public void getProviderFromNode(IProgressMonitor monitor) throws ExecutionException {
        List<IBaseEventInfo> eventInfos = this.getControlService().getKernelProvider(monitor);
        if (!eventInfos.isEmpty()) {
            KernelProviderComponent component = new KernelProviderComponent(Messages.TraceControl_KernelProviderDisplayName, this);
            this.addChild(component);
            component.setEventInfo(eventInfos);
        }
        List<IUstProviderInfo> allProviders = this.getControlService().getUstProvider(monitor);
        for (IUstProviderInfo ustProviderInfo : allProviders) {
            UstProviderComponent ustComponent = new UstProviderComponent(ustProviderInfo.getName(), this);
            this.addChild(ustComponent);
            ustComponent.setUstProvider(ustProviderInfo);
        }
    }

    public boolean hasKernelProvider() {
        List<ITraceControlComponent> kernelList = this.getChildren(KernelProviderComponent.class);
        return !kernelList.isEmpty();
    }

    public boolean isEventFilteringSupported(boolean isKernel) {
        return ((TargetNodeComponent)this.getParent()).isEventFilteringSupported(isKernel);
    }
}

