/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;

public class CPPASTCompoundStatement
extends CPPASTAttributeOwner
implements ICPPASTCompoundStatement {
    private IASTStatement[] statements = new IASTStatement[2];
    private ICPPScope scope;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    @Override
    public CPPASTCompoundStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCompoundStatement copy(IASTNode.CopyStyle style) {
        CPPASTCompoundStatement copy = new CPPASTCompoundStatement();
        IASTStatement[] iASTStatementArray = this.getStatements();
        int n = iASTStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            if (statement == null) break;
            copy.addStatement(statement.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTStatement[] getStatements() {
        this.statements = ArrayUtil.trim(this.statements);
        return this.statements;
    }

    @Override
    public void addStatement(IASTStatement statement) {
        this.assertNotFrozen();
        this.statements = ArrayUtil.append(this.statements, statement);
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(NESTED_STATEMENT);
        }
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getLocalVariablesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        IASTStatement[] iASTStatementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            if (statement == null) break;
            if (!statement.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTCompoundStatement.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i] == child) {
                other.setParent(this.statements[i].getParent());
                other.setPropertyInParent(this.statements[i].getPropertyInParent());
                this.statements[i] = (IASTStatement)other;
                return;
            }
            ++i;
        }
        super.replace(child, other);
    }
}

