/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;

public final class InstantiationContext {
    private CPPTemplateParameterMap parameterMap;
    private int packOffset;
    private final ICPPTypeSpecialization contextTypeSpecialization;
    private final IASTNode point;
    private boolean expandPack;
    private boolean packExpanded;

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, int packOffset, ICPPTypeSpecialization contextTypeSpecialization, IASTNode point) {
        this.parameterMap = (CPPTemplateParameterMap)parameterMap;
        this.packOffset = packOffset;
        this.contextTypeSpecialization = contextTypeSpecialization;
        this.point = point;
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, ICPPTypeSpecialization contextTypeSpecialization, IASTNode point) {
        this(parameterMap, -1, contextTypeSpecialization, point);
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, int packOffset, IASTNode point) {
        this(parameterMap, packOffset, null, point);
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, IASTNode point) {
        this(parameterMap, -1, null, point);
    }

    public ICPPTemplateParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public void addToParameterMap(ICPPTemplateParameter par, ICPPTemplateArgument arg) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap(1);
        }
        this.parameterMap.put(par, arg);
    }

    public void addToParameterMap(ICPPTemplateParameter par, ICPPTemplateArgument[] args) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap(1);
        }
        this.parameterMap.put(par, args);
    }

    public void addToParameterMap(ICPPTemplateParameterMap toAdd) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap((CPPTemplateParameterMap)toAdd);
        } else {
            this.parameterMap.putAll(toAdd);
        }
    }

    public ICPPTypeSpecialization getContextTypeSpecialization() {
        return this.contextTypeSpecialization;
    }

    public ICPPClassSpecialization getContextClassSpecialization() {
        return InstantiationContext.getContextClassSpecialization(this.contextTypeSpecialization);
    }

    public final IASTNode getPoint() {
        return this.point;
    }

    public boolean hasPackOffset() {
        return this.packOffset != -1;
    }

    public int getPackOffset() {
        return this.packOffset;
    }

    public void setPackOffset(int packOffset) {
        this.packOffset = packOffset;
    }

    public boolean shouldExpandPack() {
        return this.expandPack;
    }

    public void setExpandPack(boolean expand) {
        this.expandPack = expand;
    }

    public boolean isPackExpanded() {
        return this.packExpanded;
    }

    public void setPackExpanded(boolean expanded) {
        this.packExpanded = expanded;
    }

    public ICPPTemplateArgument getArgument(ICPPTemplateParameter param) {
        return this.parameterMap == null ? null : this.parameterMap.getArgument(param, this.packOffset);
    }

    public ICPPTemplateArgument[] getPackExpansion(ICPPTemplateParameter param) {
        return this.parameterMap == null ? null : this.parameterMap.getPackExpansion(param);
    }

    public static ICPPClassSpecialization getContextClassSpecialization(IBinding owner) {
        if (owner instanceof ICPPEnumerationSpecialization) {
            owner = owner.getOwner();
        }
        if (owner instanceof ICPPClassSpecialization) {
            return (ICPPClassSpecialization)owner;
        }
        return null;
    }
}

