/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.criticalpath;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.CriticalPathAlgorithmBounded;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CriticalPathModule
extends TmfAbstractAnalysisModule {
    public static final String ANALYSIS_ID = "org.eclipse.tracecompass.analysis.graph.core.criticalpath";
    public static final String PARAM_GRAPH = "graph";
    public static final String PARAM_WORKER = "workerid";
    private @Nullable TmfGraphBuilderModule fGraphModule;
    private volatile @Nullable TmfGraph fCriticalPath;

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        TmfGraphBuilderModule graphModule = this.getGraph();
        if (graphModule == null) {
            Activator.getInstance().logWarning("No graph was found to execute the critical path on");
            return true;
        }
        graphModule.schedule();
        monitor.setTaskName(NLS.bind((String)Messages.CriticalPathModule_waitingForGraph, (Object)graphModule.getName()));
        if (!graphModule.waitForCompletion(monitor)) {
            Activator.getInstance().logInfo("Critical path execution: graph building was cancelled.  Results may not be accurate.");
            return false;
        }
        TmfGraph graph = graphModule.getGraph();
        if (graph == null) {
            throw new TmfAnalysisException("Critical Path analysis: graph " + graphModule.getName() + " is null");
        }
        Object workerObj = this.getParameter(PARAM_WORKER);
        if (workerObj == null) {
            return false;
        }
        if (!(workerObj instanceof IGraphWorker)) {
            throw new IllegalStateException("Worker parameter must be an IGraphWorker");
        }
        IGraphWorker worker = (IGraphWorker)workerObj;
        TmfVertex head = graph.getHead(worker);
        if (head == null) {
            this.fCriticalPath = new TmfGraph();
            return true;
        }
        ICriticalPathAlgorithm cp = CriticalPathModule.getAlgorithm(graph);
        try {
            this.fCriticalPath = cp.compute(head, null);
            return true;
        }
        catch (CriticalPathAlgorithmException e) {
            Activator.getInstance().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), (Throwable)e);
            return false;
        }
    }

    protected void canceling() {
    }

    public @Nullable Object getParameter(String name) {
        if (name.equals(PARAM_GRAPH)) {
            return this.getGraph();
        }
        return super.getParameter(name);
    }

    public synchronized void setParameter(String name, @Nullable Object value) throws RuntimeException {
        if (name.equals(PARAM_GRAPH) && value instanceof String) {
            this.setGraph((String)value);
        }
        super.setParameter(name, value);
    }

    protected void parameterChanged(String name) {
        this.fCriticalPath = null;
        this.cancel();
        this.resetAnalysis();
        this.schedule();
    }

    private void setGraph(String graphName) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        IAnalysisModule module = trace.getAnalysisModule(graphName);
        if (module instanceof TmfGraphBuilderModule) {
            this.fGraphModule = (TmfGraphBuilderModule)module;
        }
    }

    private @Nullable TmfGraphBuilderModule getGraph() {
        TmfGraphBuilderModule module = this.fGraphModule;
        if (module == null) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return this.fGraphModule;
            }
            Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TmfGraphBuilderModule.class).iterator();
            if (iterator.hasNext()) {
                TmfGraphBuilderModule mod;
                module = mod = (TmfGraphBuilderModule)((Object)iterator.next());
            }
            if (module != null) {
                this.fGraphModule = module;
            }
        }
        return module;
    }

    private static ICriticalPathAlgorithm getAlgorithm(TmfGraph graph) {
        return new CriticalPathAlgorithmBounded(graph);
    }

    public boolean canExecute(@NonNull ITmfTrace trace) {
        return true;
    }

    public @Nullable TmfGraph getCriticalPath() {
        return this.fCriticalPath;
    }

    protected @NonNull String getFullHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_fullHelpText);
    }

    protected @NonNull String getShortHelpText(ITmfTrace trace) {
        return this.getFullHelpText();
    }

    protected @NonNull String getTraceCannotExecuteHelpText(@NonNull ITmfTrace trace) {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_cantExecute);
    }
}

