/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathEntry;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class CriticalPathPresentationProvider
extends TimeGraphPresentationProvider {
    public String getStateTypeName() {
        return Messages.getMessage(Messages.CriticalFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        StateItem[] stateTable = new StateItem[State.values().length];
        int i = 0;
        while (i < stateTable.length) {
            State state = State.values()[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            return ((TimeEvent)event).getValue();
        }
        return -2;
    }

    private static State getMatchingState(int status) {
        switch (status) {
            case 0: {
                return State.RUNNING;
            }
            case 1: {
                return State.INTERRUPTED;
            }
            case 2: {
                return State.PREEMPTED;
            }
            case 3: {
                return State.TIMER;
            }
            case 4: {
                return State.BLOCK_DEVICE;
            }
            case 5: {
                return State.USER_INPUT;
            }
            case 6: {
                return State.NETWORK;
            }
            case 7: {
                return State.IPI;
            }
        }
        return State.UNKNOWN;
    }

    public String getEventName(@Nullable ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return NonNullUtils.nullToEmptyString((Object)((Object)CriticalPathPresentationProvider.getMatchingState(ev.getValue())));
        }
        return Messages.getMessage(Messages.CriticalFlowView_multipleStates);
    }

    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry;
        LinkedHashMap<String, String> eventHoverToolTipInfo = super.getEventHoverToolTipInfo(event, hoverTime);
        if (eventHoverToolTipInfo == null) {
            eventHoverToolTipInfo = new LinkedHashMap<String, String>();
        }
        if ((entry = event.getEntry()) instanceof CriticalPathEntry) {
            CriticalPathEntry criticalPathEntry = (CriticalPathEntry)entry;
            Map info = criticalPathEntry.getWorker().getWorkerInformation(hoverTime);
            eventHoverToolTipInfo.putAll(info);
        }
        return eventHoverToolTipInfo;
    }

    public static enum State {
        RUNNING(new RGB(51, 153, 0)),
        INTERRUPTED(new RGB(255, 220, 0)),
        PREEMPTED(new RGB(200, 100, 0)),
        TIMER(new RGB(51, 102, 153)),
        BLOCK_DEVICE(new RGB(102, 0, 204)),
        USER_INPUT(new RGB(90, 1, 1)),
        NETWORK(new RGB(255, 155, 255)),
        IPI(new RGB(102, 102, 204)),
        UNKNOWN(new RGB(64, 59, 51));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

