/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiIRQ;

public class LamiIRQTypeAspect
extends LamiTableEntryAspect {
    private final int fColIndex;

    public LamiIRQTypeAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (" + Messages.LamiAspect_Type + ')', null);
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isTimeStamp() {
        return false;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiIRQ) {
            LamiIRQ irq = (LamiIRQ)data;
            switch (irq.getType()) {
                case HARD: {
                    return Messages.LamiIRQTypeAspect_HardwareIRQ;
                }
                case SOFT: {
                    return Messages.LamiIRQTypeAspect_SoftIRQ;
                }
            }
            return "?";
        }
        return data.toString();
    }

    @Override
    public @Nullable Double resolveDouble(LamiTableEntry entry) {
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return (o1, o2) -> {
            String s1 = this.resolveString((LamiTableEntry)o1);
            String s2 = this.resolveString((LamiTableEntry)o2);
            if (s1 == null || s2 == null) {
                return 0;
            }
            return s1.compareTo(s2);
        };
    }
}

