/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;

public abstract class LamiTableEntryAspect {
    private final String fName;
    private final @Nullable String fUnits;

    protected LamiTableEntryAspect(String name, @Nullable String units) {
        this.fUnits = units;
        this.fName = name;
    }

    public String getLabel() {
        if (this.getUnits() == null) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + " (" + this.getUnits() + ')';
    }

    public String getName() {
        return this.fName;
    }

    public @Nullable String getUnits() {
        return this.fUnits;
    }

    public abstract boolean isContinuous();

    public abstract boolean isTimeStamp();

    public boolean isTimeDuration() {
        return false;
    }

    public abstract @Nullable String resolveString(LamiTableEntry var1);

    public abstract @Nullable Double resolveDouble(LamiTableEntry var1);

    public abstract Comparator<LamiTableEntry> getComparator();

    public boolean arePropertiesEqual(LamiTableEntryAspect aspect) {
        boolean numerical;
        boolean timestamp = this.isTimeStamp() == aspect.isTimeStamp();
        boolean bl = numerical = this.isContinuous() == aspect.isContinuous();
        return timestamp && numerical;
    }
}

