/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;

public class LamiTableEntry {
    private final List<LamiData> fValues;

    public LamiTableEntry(List<LamiData> values) {
        this.fValues = (List)NonNullUtils.checkNotNull((Object)ImmutableList.copyOf(values));
    }

    public LamiData getValue(int index) {
        return this.fValues.get(index);
    }

    public @Nullable LamiTimeRange getCorrespondingTimeRange() {
        Optional<LamiTimeRange> oTimerange = this.fValues.stream().filter(data -> data instanceof LamiTimeRange).map(data -> (LamiTimeRange)data).findFirst();
        if (oTimerange.isPresent()) {
            return oTimerange.get();
        }
        List timestamps = this.fValues.stream().filter(data -> data instanceof LamiTimestamp).map(data -> (LamiTimestamp)data).collect(Collectors.toList());
        if (timestamps.size() > 1) {
            long first = ((LamiTimestamp)timestamps.get(0)).getValue();
            long second = ((LamiTimestamp)timestamps.get(1)).getValue();
            if (second >= first) {
                return new LamiTimeRange(first, second);
            }
        }
        if (!timestamps.isEmpty()) {
            long ts = ((LamiTimestamp)timestamps.get(0)).getValue();
            return new LamiTimeRange(ts, ts);
        }
        return null;
    }
}

