/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiBitrate;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiBoolean;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiCPU;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDisk;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDiskPartition;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDuration;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiEmpty;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiFileDescriptor;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiIRQ;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiInteger;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiNetworkInterface;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiNumber;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiPath;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiProcess;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiRatio;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiSize;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiString;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiSystemCall;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiUnknown;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.Messages;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class LamiData {
    private static final Map<Class<?>, Function<Object, LamiData>> PRIMITIVE_TYPE_GENERATOR;
    private static final Map<String, CheckedJSONExceptionFunction<JSONObject, LamiData>> COMPLEX_TYPE_GENERATOR;

    static {
        ImmutableMap.Builder primitiveTypeGenBuilder = ImmutableMap.builder();
        primitiveTypeGenBuilder.put(Boolean.class, o -> LamiBoolean.instance((Boolean)o));
        primitiveTypeGenBuilder.put(Integer.class, o -> new LamiInteger(((Integer)o).longValue()));
        primitiveTypeGenBuilder.put(Long.class, o -> new LamiInteger((Long)o));
        primitiveTypeGenBuilder.put(Double.class, o -> new LamiNumber((Double)o));
        primitiveTypeGenBuilder.put(String.class, o -> new LamiString((String)o));
        PRIMITIVE_TYPE_GENERATOR = primitiveTypeGenBuilder.build();
        ImmutableMap.Builder complexTypeGenBuilder = ImmutableMap.builder();
        complexTypeGenBuilder.put((Object)"bitrate", obj -> new LamiBitrate(LamiData.getJSONObjectLongValue(obj)));
        complexTypeGenBuilder.put((Object)"cpu", obj -> new LamiCPU(obj.getLong("id")));
        complexTypeGenBuilder.put((Object)"disk", obj -> new LamiDisk(LamiData.getJSONObjectStringName(obj)));
        complexTypeGenBuilder.put((Object)"duration", obj -> new LamiDuration(LamiData.getJSONObjectLongValue(obj)));
        complexTypeGenBuilder.put((Object)"part", obj -> new LamiDiskPartition(LamiData.getJSONObjectStringName(obj)));
        complexTypeGenBuilder.put((Object)"fd", obj -> new LamiFileDescriptor(obj.getLong("fd")));
        complexTypeGenBuilder.put((Object)"netif", obj -> new LamiNetworkInterface(LamiData.getJSONObjectStringName(obj)));
        complexTypeGenBuilder.put((Object)"path", obj -> new LamiPath((String)NonNullUtils.checkNotNull((Object)obj.getString("path"))));
        complexTypeGenBuilder.put((Object)"process", obj -> {
            String name = obj.optString("name");
            Long pid = obj.has("pid") ? Long.valueOf(obj.getLong("pid")) : null;
            Long tid = obj.has("tid") ? Long.valueOf(obj.getLong("tid")) : null;
            return new LamiProcess(name, pid, tid);
        });
        complexTypeGenBuilder.put((Object)"ratio", obj -> new LamiRatio(obj.getDouble("value")));
        complexTypeGenBuilder.put((Object)"irq", obj -> {
            LamiIRQ.Type irqType = LamiIRQ.Type.HARD;
            if (obj.has("hard")) {
                boolean isHardIrq = obj.getBoolean("hard");
                irqType = isHardIrq ? LamiIRQ.Type.HARD : LamiIRQ.Type.SOFT;
            }
            int nr = obj.getInt("nr");
            String name = obj.optString("name");
            return new LamiIRQ(irqType, nr, name);
        });
        complexTypeGenBuilder.put((Object)"size", obj -> new LamiSize(LamiData.getJSONObjectLongValue(obj)));
        complexTypeGenBuilder.put((Object)"syscall", obj -> new LamiSystemCall(LamiData.getJSONObjectStringName(obj)));
        complexTypeGenBuilder.put((Object)"time-range", obj -> {
            long begin = obj.getLong("begin");
            long end = obj.getLong("end");
            return new LamiTimeRange(begin, end);
        });
        complexTypeGenBuilder.put((Object)"timestamp", obj -> new LamiTimestamp(LamiData.getJSONObjectLongValue(obj)));
        complexTypeGenBuilder.put((Object)"unknown", obj -> LamiUnknown.INSTANCE);
        COMPLEX_TYPE_GENERATOR = complexTypeGenBuilder.build();
    }

    public abstract @Nullable String toString();

    private static final long getJSONObjectLongValue(JSONObject obj) throws JSONException {
        return obj.getLong("value");
    }

    private static final String getJSONObjectStringName(JSONObject obj) throws JSONException {
        return (String)NonNullUtils.checkNotNull((Object)obj.getString("name"));
    }

    public static LamiData createFromObject(Object obj) throws JSONException {
        if (obj instanceof JSONObject) {
            return LamiData.createFromJsonObject((JSONObject)obj);
        }
        if (obj.equals(JSONObject.NULL)) {
            return LamiEmpty.INSTANCE;
        }
        return LamiData.createFromPrimitiveObject(obj);
    }

    private static LamiData createFromPrimitiveObject(Object obj) throws JSONException {
        Function<Object, LamiData> func = PRIMITIVE_TYPE_GENERATOR.get(obj.getClass());
        if (func == null) {
            throw new JSONException("Unhandled type: " + obj.toString() + " of type " + obj.getClass().toString());
        }
        return (LamiData)NonNullUtils.checkNotNull((Object)func.apply(obj));
    }

    private static LamiData createFromJsonObject(JSONObject obj) throws JSONException {
        String dataClass = obj.optString("class");
        if (dataClass == null) {
            throw new JSONException("Cannot find data class");
        }
        CheckedJSONExceptionFunction<JSONObject, LamiData> func = COMPLEX_TYPE_GENERATOR.get(dataClass);
        if (func == null) {
            throw new JSONException(String.format("Unsupported data class \"%s\"", dataClass));
        }
        return func.apply(obj);
    }

    @FunctionalInterface
    private static interface CheckedJSONExceptionFunction<T, R> {
        public R apply(T var1) throws JSONException;
    }

    public static enum DataType {
        STRING("string", "Value", false, null, LamiString.class),
        INT("int", "Value", true, null, LamiInteger.class),
        FLOAT("float", "Value", true, null, LamiNumber.class),
        NUMBER("number", "Value", true, null, LamiNumber.class),
        BOOL("bool", "Value", false, null, LamiBoolean.class),
        RATIO("ratio", "Ratio", true, "%", LamiRatio.class),
        TIMESTAMP("timestamp", "Timestamp", true, "ns", LamiTimestamp.class),
        TIME_RANGE("time-range", "Time range", true, null, LamiTimeRange.class),
        DURATION("duration", "Duration", true, "ns", LamiDuration.class),
        SIZE("size", "Size", true, Messages.LamiData_UnitBytes, LamiSize.class),
        BITRATE("bitrate", "Bitrate", true, Messages.LamiData_UnitBitsPerSecond, LamiBitrate.class),
        SYSCALL("syscall", "System call", false, null, LamiSystemCall.class),
        PROCESS("process", "Process", false, null, LamiProcess.class),
        PATH("path", "Path", false, null, LamiPath.class),
        FD("fd", "File descriptor", false, null, LamiFileDescriptor.class),
        IRQ("irq", "IRQ", false, null, LamiIRQ.class),
        CPU("cpu", "CPU", false, null, LamiCPU.class),
        DISK("disk", "Disk", false, null, LamiDisk.class),
        PART("part", "Disk partition", false, null, LamiDiskPartition.class),
        NETIF("netif", "Network interface", false, null, LamiNetworkInterface.class),
        UNKNOWN("unknown", "Value", false, null, LamiUnknown.class),
        MIXED("mixed", "Value", false, null, null);

        private final String fName;
        private final String fTitle;
        private final boolean fIsContinuous;
        private final @Nullable String fUnits;
        private final @Nullable Class<?> fClass;

        private DataType(String name, @Nullable String title, @Nullable boolean isContinous, String units, Class<?> cls) {
            this.fName = name;
            this.fTitle = title;
            this.fIsContinuous = isContinous;
            this.fUnits = units;
            this.fClass = cls;
        }

        public boolean isContinuous() {
            return this.fIsContinuous;
        }

        public @Nullable String getUnits() {
            return this.fUnits;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public static DataType fromString(String value) {
            DataType[] dataTypeArray = DataType.values();
            int n = dataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataType type = dataTypeArray[n2];
                if (type.fName.equals(value)) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unrecognized type: " + value);
        }

        public static @Nullable DataType fromClass(Class<? extends LamiData> cls) {
            DataType[] dataTypeArray = DataType.values();
            int n = dataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataType type = dataTypeArray[n2];
                if (cls.equals(type.fClass)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

