/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import com.google.common.collect.ImmutableList;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTimeStampFormat;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.signals.LamiSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.ILamiViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.ui.PlatformUI;
import org.swtchart.Chart;
import org.swtchart.ITitle;

public abstract class LamiXYChartViewer
extends TmfViewer
implements ILamiViewer {
    protected static final String ELLIPSIS = "\u2026";
    protected static final String UNKNOWN = "?";
    protected static final double ZERO = 0.0;
    private static final String SECONDS_SYMBOL = "s";
    private static final String NANOSECONDS_SYMBOL = "ns";
    protected static final ToDoubleFunction<@Nullable String> DOUBLE_MAPPER = str -> {
        if (str == null || str.equals(UNKNOWN)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    };
    protected static final List<@NonNull Color> COLORS = ImmutableList.of((Object)new Color((Device)Display.getDefault(), 72, 120, 207), (Object)new Color((Device)Display.getDefault(), 106, 204, 101), (Object)new Color((Device)Display.getDefault(), 214, 95, 95), (Object)new Color((Device)Display.getDefault(), 180, 124, 199), (Object)new Color((Device)Display.getDefault(), 196, 173, 102), (Object)new Color((Device)Display.getDefault(), 119, 190, 219));
    protected static final List<@NonNull Color> LIGHT_COLORS = ImmutableList.of((Object)new Color((Device)Display.getDefault(), 173, 195, 233), (Object)new Color((Device)Display.getDefault(), 199, 236, 197), (Object)new Color((Device)Display.getDefault(), 240, 196, 196), (Object)new Color((Device)Display.getDefault(), 231, 213, 237), (Object)new Color((Device)Display.getDefault(), 231, 222, 194), (Object)new Color((Device)Display.getDefault(), 220, 238, 246));
    protected static final LamiTimeStampFormat DAYS_FORMATTER = new LamiTimeStampFormat("dd HH:mm");
    protected static final LamiTimeStampFormat HOURS_FORMATTER = new LamiTimeStampFormat("HH:mm");
    protected static final LamiTimeStampFormat MINUTES_FORMATTER = new LamiTimeStampFormat("mm:ss");
    protected static final LamiTimeStampFormat SECONDS_FORMATTER = new LamiTimeStampFormat("ss");
    protected static final LamiTimeStampFormat MILLISECONDS_FORMATTER = new LamiTimeStampFormat("ss.SSS");
    protected static final DecimalUnitFormat NANO_TO_SECS_FORMATTER = new DecimalUnitFormat(1.0E-9);
    protected static final DecimalUnitFormat DECIMAL_FORMATTER = new DecimalUnitFormat();
    private final Listener fResizeListener = event -> {
        this.refreshDisplayTitles();
        this.refreshDisplayLabels();
    };
    private final LamiResultTable fResultTable;
    private final LamiChartModel fChartModel;
    private final Chart fChart;
    private final String fChartTitle;
    private final String fXTitle;
    private final String fYTitle;
    private boolean fSelected;
    private Set<Integer> fSelection;
    private final ToolBar fToolBar;

    public LamiXYChartViewer(Composite parent, LamiResultTable resultTable, LamiChartModel chartModel) {
        super(parent);
        String units;
        long nbDiffAspectName;
        this.fParent = parent;
        this.fResultTable = resultTable;
        this.fChartModel = chartModel;
        this.fSelection = new HashSet<Integer>();
        this.fChart = new Chart(parent, 0);
        this.fChart.addListener(11, this.fResizeListener);
        this.fChartTitle = this.fResultTable.getTableClass().getTableTitle();
        if (this.fChartModel.getXSeriesColumns().size() == 1) {
            String seriesName = (String)this.getChartModel().getXSeriesColumns().get(0);
            if (NANOSECONDS_SYMBOL.equals(this.getXAxisAspects().get(0).getUnits())) {
                seriesName = String.valueOf(this.getXAxisAspects().get(0).getName()) + " (" + SECONDS_SYMBOL + ')';
            }
            this.fXTitle = seriesName;
        } else {
            long nbDiffAspectsUnits = this.getXAxisAspects().stream().map(aspect -> aspect.getUnits()).distinct().count();
            nbDiffAspectName = this.getXAxisAspects().stream().map(aspect -> aspect.getName()).distinct().count();
            String xBaseTitle = Messages.LamiViewer_DefaultValueName;
            if (nbDiffAspectName == 1L) {
                xBaseTitle = this.getXAxisAspects().get(0).getName();
            }
            units = this.getXAxisAspects().get(0).getUnits();
            if (nbDiffAspectsUnits == 1L && units != null) {
                if (NANOSECONDS_SYMBOL.equals(units)) {
                    units = SECONDS_SYMBOL;
                }
                this.fXTitle = String.valueOf(xBaseTitle) + " (" + units + ')';
            } else {
                this.fXTitle = NonNullUtils.nullToEmptyString((Object)xBaseTitle);
            }
        }
        if (this.fChartModel.getYSeriesColumns().size() == 1) {
            String seriesName = (String)this.getChartModel().getYSeriesColumns().get(0);
            if (NANOSECONDS_SYMBOL.equals(this.getYAxisAspects().get(0).getUnits())) {
                seriesName = String.valueOf(this.getYAxisAspects().get(0).getName()) + " (" + SECONDS_SYMBOL + ')';
            }
            this.fYTitle = seriesName;
            this.fChart.getLegend().setVisible(false);
        } else {
            long nbDiffAspectsUnits = this.getYAxisAspects().stream().map(aspect -> aspect.getUnits()).distinct().count();
            nbDiffAspectName = this.getYAxisAspects().stream().map(aspect -> aspect.getName()).distinct().count();
            String yBaseTitle = Messages.LamiViewer_DefaultValueName;
            if (nbDiffAspectName == 1L) {
                yBaseTitle = this.getYAxisAspects().get(0).getName();
            }
            units = this.getYAxisAspects().get(0).getUnits();
            if (nbDiffAspectsUnits == 1L && units != null) {
                if (NANOSECONDS_SYMBOL.equals(units)) {
                    units = SECONDS_SYMBOL;
                }
                this.fYTitle = String.valueOf(yBaseTitle) + " (" + units + ')';
            } else {
                this.fYTitle = NonNullUtils.nullToEmptyString((Object)yBaseTitle);
            }
            this.fChart.getLegend().setPosition(1024);
        }
        this.fChart.getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getYAxis(0).getTitle().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTick().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getYAxis(0).getTick().setForeground(Display.getDefault().getSystemColor(2));
        this.fChart.getAxisSet().getXAxis(0).getTick().setTickLabelAngle(90);
        this.refreshDisplayTitles();
        this.fToolBar = this.createChartToolBar();
        this.fChart.addDisposeListener(e -> LamiXYChartViewer.super.dispose());
    }

    protected static boolean areAspectsContinuous(List<LamiTableEntryAspect> axisAspects) {
        return axisAspects.stream().allMatch(aspect -> aspect.isContinuous());
    }

    protected static boolean areAspectsTimeStamp(List<LamiTableEntryAspect> axisAspects) {
        return axisAspects.stream().allMatch(aspect -> aspect.isTimeStamp());
    }

    protected static boolean areAspectsTimeDuration(List<LamiTableEntryAspect> axisAspects) {
        return axisAspects.stream().allMatch(aspect -> aspect.isTimeDuration());
    }

    protected static Format getContinuousAxisFormatter(List<LamiTableEntryAspect> axisAspects, List<LamiTableEntry> entries) {
        if (LamiXYChartViewer.areAspectsTimeStamp(axisAspects)) {
            double max = Double.MIN_VALUE;
            double min = Double.MAX_VALUE;
            for (LamiTableEntry entry : entries) {
                for (LamiTableEntryAspect aspect : axisAspects) {
                    Double current = aspect.resolveDouble(entry);
                    if (current == null) continue;
                    max = Math.max(max, current);
                    min = Math.min(min, current);
                }
            }
            long duration = (long)max - (long)min;
            if (duration > TimeUnit.DAYS.toNanos(1L)) {
                return DAYS_FORMATTER;
            }
            if (duration > TimeUnit.HOURS.toNanos(1L)) {
                return HOURS_FORMATTER;
            }
            if (duration > TimeUnit.MINUTES.toNanos(1L)) {
                return MINUTES_FORMATTER;
            }
            if (duration > TimeUnit.SECONDS.toNanos(15L)) {
                return SECONDS_FORMATTER;
            }
            return MILLISECONDS_FORMATTER;
        }
        if (LamiXYChartViewer.areAspectsTimeDuration(axisAspects)) {
            return NANO_TO_SECS_FORMATTER;
        }
        return DECIMAL_FORMATTER;
    }

    protected LamiResultTable getResultTable() {
        return this.fResultTable;
    }

    protected LamiChartModel getChartModel() {
        return this.fChartModel;
    }

    protected Chart getChart() {
        return this.fChart;
    }

    public ToolBar getToolBar() {
        return this.fToolBar;
    }

    protected boolean isSelected() {
        return this.fSelected;
    }

    protected void setSelection(Set<Integer> selection) {
        this.fSelection = selection;
        this.fSelected = !selection.isEmpty();
    }

    protected void unsetSelection() {
        this.fSelection.clear();
        this.fSelected = false;
    }

    protected Set<Integer> getSelection() {
        return this.fSelection;
    }

    public @Nullable Control getControl() {
        return this.fChart.getParent();
    }

    public void refresh() {
        Display.getDefault().asyncExec(() -> {
            if (!this.fChart.isDisposed()) {
                this.fChart.redraw();
            }
        });
    }

    @Override
    public void dispose() {
        this.fChart.dispose();
    }

    protected List<LamiTableEntryAspect> getYAxisAspects() {
        ArrayList<LamiTableEntryAspect> yAxisAspects = new ArrayList<LamiTableEntryAspect>();
        for (String colName : this.getChartModel().getYSeriesColumns()) {
            yAxisAspects.add((LamiTableEntryAspect)NonNullUtils.checkNotNull((Object)LamiXYChartViewer.getAspectFromName(this.getResultTable().getTableClass().getAspects(), colName)));
        }
        return yAxisAspects;
    }

    protected List<LamiTableEntryAspect> getXAxisAspects() {
        ArrayList<LamiTableEntryAspect> xAxisAspects = new ArrayList<LamiTableEntryAspect>();
        for (String colName : this.getChartModel().getXSeriesColumns()) {
            xAxisAspects.add((LamiTableEntryAspect)NonNullUtils.checkNotNull((Object)LamiXYChartViewer.getAspectFromName(this.getResultTable().getTableClass().getAspects(), colName)));
        }
        return xAxisAspects;
    }

    private void refreshDisplayTitle(ITitle title, String canonicalTitle, int maxPixelLength) {
        if (title.isVisible()) {
            String newTitle = canonicalTitle;
            Font font = title.getFont();
            GC gc = new GC((Drawable)this.fParent);
            gc.setFont(font);
            Point pixels = gc.stringExtent(canonicalTitle);
            if (pixels.x > maxPixelLength) {
                int minimum;
                int charwidth = gc.getFontMetrics().getAverageCharWidth();
                int strLen = maxPixelLength / charwidth - (minimum = 3);
                newTitle = strLen > minimum ? String.valueOf(canonicalTitle.substring(0, strLen)) + ELLIPSIS : ELLIPSIS;
            }
            title.setText(newTitle);
            gc.dispose();
        }
    }

    private void refreshDisplayTitles() {
        Rectangle chartRect = this.fChart.getClientArea();
        Rectangle plotRect = this.fChart.getPlotArea().getClientArea();
        ITitle chartTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getTitle());
        this.refreshDisplayTitle(chartTitle, this.fChartTitle, chartRect.width);
        ITitle xTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getAxisSet().getXAxis(0).getTitle());
        this.refreshDisplayTitle(xTitle, this.fXTitle, plotRect.width);
        ITitle yTitle = (ITitle)NonNullUtils.checkNotNull((Object)this.fChart.getAxisSet().getYAxis(0).getTitle());
        this.refreshDisplayTitle(yTitle, this.fYTitle, plotRect.height);
    }

    protected static @Nullable LamiTableEntryAspect getAspectFromName(List<LamiTableEntryAspect> aspects, String aspectName) {
        for (LamiTableEntryAspect lamiTableEntryAspect : aspects) {
            if (!lamiTableEntryAspect.getLabel().equals(aspectName)) continue;
            return lamiTableEntryAspect;
        }
        return null;
    }

    protected abstract void refreshDisplayLabels();

    protected void redraw() {
        this.refresh();
    }

    @TmfSignalHandler
    public void updateSelection(LamiSelectionUpdateSignal signal) {
        if (this.getResultTable().hashCode() != signal.getSignalHash() || this.equals(signal.getSource())) {
            return;
        }
        this.setSelection(signal.getEntryIndex());
        this.redraw();
    }

    protected ToolBar createChartToolBar() {
        Image removeImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
        final ToolBar toolBar = new ToolBar((Composite)this.getChart(), 256);
        toolBar.moveAbove(null);
        toolBar.setVisible(false);
        ToolItem closeButton = new ToolItem(toolBar, 8);
        closeButton.setImage(removeImage);
        closeButton.setToolTipText(Messages.LamiXYChartViewer_CloseChartToolTip);
        closeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                Composite parent = LamiXYChartViewer.this.getParent();
                LamiXYChartViewer.this.dispose();
                parent.layout();
            }

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
            }
        });
        toolBar.pack();
        toolBar.setLocation(new Point(this.getChart().getSize().x - toolBar.getSize().x, 0));
        Listener toolBarVisibilityToggleListener = e -> {
            if (e.widget instanceof Control) {
                Control control = (Control)e.widget;
                Point display = control.toDisplay(e.x, e.y);
                Point location = this.getChart().getParent().toControl(display);
                boolean visible = this.getChart().getBounds().contains(location) && control.getShell().equals(this.getChart().getShell());
                this.getToolBar().setVisible(visible);
            }
        };
        Listener hideToolBarListener = e -> this.getToolBar().setVisible(false);
        Display display = this.getChart().getDisplay();
        display.addFilter(6, toolBarVisibilityToggleListener);
        display.addFilter(7, hideToolBarListener);
        this.getChart().addDisposeListener(e -> {
            display.removeFilter(6, toolBarVisibilityToggleListener);
            display.removeFilter(7, hideToolBarListener);
        });
        this.getChart().addListener(11, new Listener(){

            public void handleEvent(@Nullable Event event) {
                toolBar.setLocation(new Point(LamiXYChartViewer.this.getChart().getSize().x - toolBar.getSize().x, 0));
            }
        });
        return toolBar;
    }
}

