/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.SegmentStoreContentProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.table.TmfSimpleTableViewer;

public abstract class AbstractSegmentStoreTableViewer
extends TmfSimpleTableViewer {
    private @Nullable ISegmentStoreProvider fSegmentProvider = null;
    private SegmentStoreProviderProgressListener fListener;
    boolean fColumnsCreated = false;

    public AbstractSegmentStoreTableViewer(TableViewer tableViewer) {
        super(tableViewer);
        this.getTableViewer().setContentProvider((IContentProvider)new SegmentStoreContentProvider());
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.fSegmentProvider = this.getSegmentStoreProvider(trace);
        }
        this.createColumns();
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new TableSelectionListener());
        this.addPackListener();
        this.fListener = new SegmentStoreProviderProgressListener();
    }

    private void createColumns() {
        this.createColumn(Messages.SegmentStoreTableViewer_startTime, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)TmfTimestampFormat.getDefaulTimeFormat().format(input.getStart()));
            }
        }, SegmentComparators.INTERVAL_START_COMPARATOR);
        this.createColumn(Messages.SegmentStoreTableViewer_endTime, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)TmfTimestampFormat.getDefaulTimeFormat().format(input.getEnd()));
            }
        }, SegmentComparators.INTERVAL_END_COMPARATOR);
        this.createColumn(Messages.SegmentStoreTableViewer_duration, new SegmentStoreTableColumnLabelProvider(this){

            @Override
            public String getTextForSegment(ISegment input) {
                return NonNullUtils.nullToEmptyString((Object)Long.toString(input.getLength()));
            }
        }, SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
    }

    protected void createProviderColumns() {
        if (!this.fColumnsCreated) {
            ISegmentStoreProvider provider = this.getSegmentProvider();
            if (provider != null) {
                for (final ISegmentAspect aspect : provider.getSegmentAspects()) {
                    this.createColumn(aspect.getName(), new SegmentStoreTableColumnLabelProvider(this){

                        @Override
                        public String getTextForSegment(ISegment input) {
                            return NonNullUtils.nullToEmptyString((Object)aspect.resolve(input));
                        }
                    }, aspect.getComparator());
                }
            }
            this.fColumnsCreated = true;
        }
    }

    public void updateModel(final @Nullable Object dataInput) {
        final TableViewer tableViewer = this.getTableViewer();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!tableViewer.getTable().isDisposed()) {
                    tableViewer.getTable().setTopIndex(0);
                    tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    if (dataInput == null) {
                        tableViewer.setInput(null);
                        tableViewer.setItemCount(0);
                        return;
                    }
                    AbstractSegmentStoreTableViewer.this.addPackListener();
                    tableViewer.setInput(dataInput);
                    SegmentStoreContentProvider contentProvider = (SegmentStoreContentProvider)AbstractSegmentStoreTableViewer.this.getTableViewer().getContentProvider();
                    tableViewer.setItemCount(contentProvider.getSegmentCount());
                }
            }
        });
    }

    public void setData(@Nullable ISegmentStoreProvider provider) {
        this.fSegmentProvider = provider;
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        this.createProviderColumns();
        ISegmentStore segStore = provider.getSegmentStore();
        if (segStore != null) {
            this.updateModel(segStore);
            return;
        }
        this.updateModel(null);
        provider.addListener((IAnalysisProgressListener)this.fListener);
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        final ISegment segment = (ISegment)sel.getFirstElement();
        if (segment != null) {
            Action gotoStartTime = new Action(Messages.SegmentStoreTableViewer_goToStartEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getStart())));
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreTableViewer_goToEndEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getEnd())));
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
        }
    }

    public @Nullable ISegmentStoreProvider getSegmentProvider() {
        return this.fSegmentProvider;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (TmfTraceManager.getInstance().getActiveTrace() == null) {
            ISegmentStoreProvider provider;
            if (!this.getTableViewer().getTable().isDisposed()) {
                this.getTableViewer().setInput(null);
                this.getTableViewer().setItemCount(0);
                this.refresh();
            }
            if ((provider = this.getSegmentProvider()) != null) {
                provider.removeListener((IAnalysisProgressListener)this.fListener);
            }
        }
    }

    private void addPackListener() {
        this.getControl().addListener(36, new Listener(){

            public void handleEvent(@Nullable Event event) {
                AbstractSegmentStoreTableViewer.this.getControl().removeListener(36, (Listener)this);
                TableViewer tableViewer = AbstractSegmentStoreTableViewer.this.getTableViewer();
                if (tableViewer != null) {
                    TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn col = tableColumnArray[n2];
                        col.pack();
                        ++n2;
                    }
                }
            }
        });
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider activeProvider, ISegmentStore<ISegment> data) {
            if (activeProvider.equals(AbstractSegmentStoreTableViewer.this.fSegmentProvider)) {
                AbstractSegmentStoreTableViewer.this.updateModel(data);
            }
        }
    }

    private abstract class SegmentStoreTableColumnLabelProvider
    extends ColumnLabelProvider {
        private SegmentStoreTableColumnLabelProvider() {
        }

        public String getText(@Nullable Object input) {
            if (!(input instanceof ISegment)) {
                return "";
            }
            return this.getTextForSegment((ISegment)input);
        }

        public abstract String getTextForSegment(ISegment var1);
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent e) {
            ISegment selectedSegment = (ISegment)((SelectionEvent)NonNullUtils.checkNotNull((Object)e)).item.getData();
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)selectedSegment.getStart());
            ITmfTimestamp end = TmfTimestamp.fromNanos((long)selectedSegment.getEnd());
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, start, end));
        }
    }
}

