/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;

public class VariantDeclaration
extends Declaration {
    private String fTag = null;
    private static final long ALIGNMENT = 1L;
    private final Map<String, IDeclaration> fFields = Collections.synchronizedMap(new HashMap());
    private IDeclaration fDeclarationToPopulate;

    public boolean isTagged() {
        return this.fTag != null;
    }

    public boolean hasField(String fieldTag) {
        return this.fFields.containsKey(fieldTag);
    }

    public void setTag(String tag) {
        this.fTag = tag;
    }

    public String getTag() {
        return this.fTag;
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFields;
    }

    @Override
    public long getAlignment() {
        return 1L;
    }

    @Override
    public VariantDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IDefinition def = definitionScope.lookupDefinition(this.fTag);
        EnumDefinition tagDef = (EnumDefinition)(def instanceof EnumDefinition ? def : null);
        if (tagDef == null) {
            throw new CTFException("Tag is not defined " + this.fTag);
        }
        String varFieldName = tagDef.getStringValue();
        if (varFieldName == null) {
            throw new CTFException("Undefined enum selector for variant " + definitionScope.getScopePath().getPath());
        }
        this.fDeclarationToPopulate = this.fFields.get(varFieldName);
        if (this.fDeclarationToPopulate == null) {
            throw new CTFException("Unknown enum selector for variant " + definitionScope.getScopePath().getPath());
        }
        Definition fieldValue = this.fDeclarationToPopulate.createDefinition(definitionScope, fieldName, input);
        return new VariantDefinition(this, definitionScope, varFieldName, fieldName, fieldValue);
    }

    public void addField(String fieldTag, IDeclaration declaration) {
        this.fFields.put(fieldTag, declaration);
    }

    @Override
    public int getMaximumSize() {
        Collection<IDeclaration> values = this.fFields.values();
        int maxSize = 0;
        for (IDeclaration field : values) {
            maxSize = Math.max(maxSize, field.getMaximumSize());
        }
        return maxSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] variant[");
        for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
            sb.append(field.getKey()).append(':').append(field.getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fDeclarationToPopulate == null ? 0 : this.fDeclarationToPopulate.hashCode());
        if (this.fFields == null) {
            result *= 31;
        } else {
            for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
                result = 31 * result + field.getValue().hashCode();
            }
        }
        result = 31 * result + (this.fTag == null ? 0 : this.fTag.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantDeclaration other = (VariantDeclaration)obj;
        if (!NonNullUtils.equalsNullable((Object)this.fDeclarationToPopulate, (Object)other.fDeclarationToPopulate)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable(this.fFields, other.fFields)) {
            return false;
        }
        return NonNullUtils.equalsNullable((Object)this.fTag, (Object)other.fTag);
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantDeclaration other = (VariantDeclaration)obj;
        if (this.fFields == null) {
            if (other.fFields != null) {
                return false;
            }
        } else {
            if (this.fFields.size() != other.fFields.size()) {
                return false;
            }
            for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
                if (!other.fFields.containsKey(field.getKey())) {
                    return false;
                }
                IDeclaration field2 = other.fFields.get(field.getKey());
                if (field2 != null && field2.isBinaryEquivalent(field.getValue())) continue;
                return false;
            }
        }
        return true;
    }
}

