/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public class EventDeclaration
implements IEventDeclaration {
    private String fName;
    private StructDeclaration fContext = null;
    private StructDeclaration fFields = null;
    private @Nullable CTFStream fStream = null;
    private long fLogLevel;
    private final Map<String, String> fCustomAttributes = new HashMap<String, String>();
    private int fId = -2;

    public EventDefinition createDefinition(StructDeclaration streamEventContextDecl, ICTFPacketDescriptor packetDescriptor, ICompositeDefinition packetContext, ICompositeDefinition eventHeaderDef, @NonNull BitBuffer input, long prevTimestamp) throws CTFException {
        CTFStream stream = this.fStream;
        CTFTrace trace = stream == null ? null : stream.getTrace();
        StructDefinition streamEventContext = streamEventContextDecl != null ? streamEventContextDecl.createDefinition((IDefinitionScope)trace, ILexicalScope.STREAM_EVENT_CONTEXT, input) : null;
        StructDefinition eventContext = this.fContext != null ? this.fContext.createFieldDefinition(eventHeaderDef, trace, ILexicalScope.CONTEXT, input) : null;
        StructDefinition eventPayload = this.fFields != null ? this.fFields.createFieldDefinition(eventHeaderDef, trace, ILexicalScope.FIELDS, input) : null;
        long timestamp = EventDeclaration.calculateTimestamp(eventHeaderDef, prevTimestamp, eventPayload, eventContext);
        int cpu = (int)packetDescriptor.getTargetId();
        return new EventDefinition(this, cpu, timestamp, eventHeaderDef, streamEventContext, eventContext, packetContext, eventPayload, packetDescriptor);
    }

    private static long calculateTimestamp(@Nullable ICompositeDefinition eventHeaderDef, long prevTimestamp, StructDefinition eventPayload, StructDefinition eventContext) throws CTFIOException {
        long timestamp = 0L;
        Definition def = null;
        if (eventHeaderDef instanceof EventHeaderDefinition) {
            EventHeaderDefinition eventHeaderDefinition = (EventHeaderDefinition)eventHeaderDef;
            timestamp = EventDeclaration.calculateTimestamp(eventHeaderDefinition.getTimestamp(), eventHeaderDefinition.getTimestampLength(), prevTimestamp);
            def = eventHeaderDefinition;
        } else if (eventHeaderDef instanceof StructDefinition) {
            StructDefinition structDefinition = (StructDefinition)eventHeaderDef;
            def = structDefinition.lookupDefinition("timestamp");
        } else if (eventHeaderDef != null) {
            throw new CTFIOException("Event header def is not a Struct or an Event Header");
        }
        if (def == null && eventPayload != null) {
            def = eventPayload.lookupDefinition("timestamp");
        }
        if (def == null && eventContext != null) {
            def = eventContext.lookupDefinition("timestamp");
        }
        if (def instanceof IntegerDefinition) {
            IntegerDefinition timestampDef = (IntegerDefinition)def;
            timestamp = EventDeclaration.calculateTimestamp(timestampDef, prevTimestamp);
        }
        return timestamp;
    }

    @Override
    public EventDefinition createDefinition(CTFStreamInputReader streamInputReader, @NonNull BitBuffer input, long timestamp) throws CTFException {
        StructDeclaration streamEventContextDecl = streamInputReader.getStreamEventContextDecl();
        @Nullable CTFStream stream = this.fStream;
        CTFTrace trace = stream == null ? null : stream.getTrace();
        StructDefinition streamEventContext = streamEventContextDecl != null ? streamEventContextDecl.createDefinition((IDefinitionScope)trace, ILexicalScope.STREAM_EVENT_CONTEXT, input) : null;
        ICompositeDefinition packetContext = streamInputReader.getCurrentPacketReader().getCurrentPacketEventHeader();
        StructDefinition eventContext = this.fContext != null ? this.fContext.createDefinition((IDefinitionScope)trace, ILexicalScope.CONTEXT, input) : null;
        StructDefinition eventPayload = this.fFields != null ? this.fFields.createDefinition((IDefinitionScope)trace, ILexicalScope.FIELDS, input) : null;
        return new EventDefinition(this, streamInputReader.getCPU(), timestamp, null, streamEventContext, eventContext, packetContext, eventPayload, streamInputReader.getCurrentPacketReader().getCurrentPacket());
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setContext(StructDeclaration context) {
        this.fContext = context;
    }

    public void setFields(StructDeclaration fields) {
        this.fFields = fields;
    }

    @Override
    public StructDeclaration getFields() {
        return this.fFields;
    }

    @Override
    public StructDeclaration getContext() {
        return this.fContext;
    }

    public void setId(long id) {
        if (id < 0L || id > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("id out of range");
        }
        this.fId = (int)id;
    }

    @Override
    public Long getId() {
        return this.fId;
    }

    public int id() {
        return this.fId;
    }

    public void setStream(CTFStream stream) {
        this.fStream = stream;
    }

    @Override
    public CTFStream getStream() {
        return this.fStream;
    }

    public boolean nameIsSet() {
        return this.fName != null;
    }

    public boolean contextIsSet() {
        return this.fContext != null;
    }

    public boolean fieldsIsSet() {
        return this.fFields != null;
    }

    public boolean idIsSet() {
        return (long)this.fId != -2L;
    }

    public boolean streamIsSet() {
        return this.fStream != null;
    }

    @Override
    public long getLogLevel() {
        return this.fLogLevel;
    }

    public void setLogLevel(long level) {
        this.fLogLevel = level;
    }

    @Override
    public Set<String> getCustomAttributes() {
        return this.fCustomAttributes.keySet();
    }

    @Override
    public String getCustomAttribute(String key) {
        return this.fCustomAttributes.get(key);
    }

    public void setCustomAttribute(String key, String value) {
        this.fCustomAttributes.put(key, value);
    }

    private static long calculateTimestamp(IntegerDefinition timestampDef, long lastTimestamp) {
        int len = timestampDef.getDeclaration().getLength();
        long value = timestampDef.getValue();
        return EventDeclaration.calculateTimestamp(value, len, lastTimestamp);
    }

    private static long calculateTimestamp(long value, int len, long prevTimestamp) {
        long lastTimestamp = prevTimestamp;
        if (len == 64) {
            lastTimestamp = value;
            return lastTimestamp;
        }
        long newval = value;
        long majorasbitmask = (1L << len) - 1L;
        if (newval < (lastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        lastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        return lastTimestamp += newval;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDeclaration)) {
            return false;
        }
        EventDeclaration other = (EventDeclaration)obj;
        if (this.fId != other.fId) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fContext, (Object)other.fContext)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fFields, (Object)other.fFields)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fName, (Object)other.fName)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fStream, (Object)other.fStream)) {
            return false;
        }
        return this.fCustomAttributes.equals(other.fCustomAttributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fContext == null ? 0 : this.fContext.hashCode());
        result = 31 * result + (this.fFields == null ? 0 : this.fFields.hashCode());
        result = 31 * result + this.fId;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        CTFStream stream = this.fStream;
        result = 31 * result + (stream == null ? 0 : stream.hashCode());
        result = 31 * result + this.fCustomAttributes.hashCode();
        return result;
    }
}

