/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputPacketIndex {
    private final List<ICTFPacketDescriptor> fEntries = new ArrayList<ICTFPacketDescriptor>();

    public int size() {
        return this.fEntries.size();
    }

    public boolean isEmpty() {
        return this.fEntries.isEmpty();
    }

    public void appendAll(Collection<ICTFPacketDescriptor> preParsedIndex) {
        for (ICTFPacketDescriptor sipie : preParsedIndex) {
            this.append((ICTFPacketDescriptor)NonNullUtils.checkNotNull((Object)sipie));
        }
    }

    public synchronized boolean append(@NonNull ICTFPacketDescriptor entry) {
        ICTFPacketDescriptor entryToAdd = entry;
        if (entryToAdd.getTimestampBegin() > entryToAdd.getTimestampEnd()) {
            Activator.log(2, "Packet at offset " + entryToAdd.getOffsetBytes() + " begin timestamp is after end timestamp");
            entryToAdd = new StreamInputPacketIndexEntry(entryToAdd, Long.MAX_VALUE);
        }
        if (!this.fEntries.isEmpty() && entryToAdd.getTimestampBegin() < this.lastElement().getTimestampBegin()) {
            return false;
        }
        this.fEntries.add(entryToAdd);
        return true;
    }

    public int search(long timestamp) {
        int index = Collections.binarySearch(this.fEntries, new StreamInputPacketIndexEntry(timestamp, 0L), new FindTimestamp());
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    public ICTFPacketDescriptor lastElement() {
        return this.fEntries.get(this.fEntries.size() - 1);
    }

    public ICTFPacketDescriptor getElement(int index) {
        return this.fEntries.get(index);
    }

    public int indexOf(ICTFPacketDescriptor element) {
        int indexOf = -1;
        if (element != null) {
            indexOf = Collections.binarySearch(this.fEntries, element, new MonotonicComparator());
        }
        return indexOf < 0 ? -1 : indexOf;
    }

    private static class FindTimestamp
    implements Comparator<ICTFPacketDescriptor>,
    Serializable {
        private static final long serialVersionUID = 7235997205945550341L;

        private FindTimestamp() {
        }

        @Override
        public int compare(ICTFPacketDescriptor value, ICTFPacketDescriptor key) {
            long ts = key.getOffsetBits();
            if (value.includes(ts)) {
                return 0;
            }
            return Long.compare(value.getTimestampBegin(), ts);
        }
    }

    private static class MonotonicComparator
    implements Comparator<ICTFPacketDescriptor>,
    Serializable {
        private static final long serialVersionUID = -5693064068367242076L;

        private MonotonicComparator() {
        }

        @Override
        public int compare(ICTFPacketDescriptor left, ICTFPacketDescriptor right) {
            if (left.getTimestampBegin() > right.getTimestampBegin()) {
                return 1;
            }
            if (left.getTimestampBegin() < right.getTimestampBegin()) {
                return -1;
            }
            if (left.getTimestampEnd() > right.getTimestampEnd()) {
                return 1;
            }
            if (left.getTimestampEnd() < right.getTimestampEnd()) {
                return -1;
            }
            return 0;
        }
    }
}

