/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.qemukvm;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.IVirtualMachineModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.VirtualCPU;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.VirtualMachine;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;

public class QemuKvmVmModel
implements IVirtualMachineModel {
    private static final String KVM = "kvm_";
    private final Map<HostThread, VirtualCPU> fTidToVcpu = new HashMap<HostThread, VirtualCPU>();
    private final Map<HostThread, VirtualMachine> fTidToVm = new HashMap<HostThread, VirtualMachine>();
    private final Map<String, VirtualMachine> fKnownMachines = new HashMap<String, VirtualMachine>();
    private final TmfExperiment fExperiment;
    static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"kvm_entry", (Object)"kvm_exit", (Object)"vmsync_gh_guest", (Object)"vmsync_gh_host", (Object)"vmsync_hg_guest", (Object)"vmsync_hg_host", (Object[])new String[0]);

    public QemuKvmVmModel(TmfExperiment exp) {
        this.fExperiment = exp;
    }

    @Override
    public @Nullable VirtualMachine getCurrentMachine(ITmfEvent event) {
        TmfEventField field;
        ITmfEventField data;
        String hostId = event.getTrace().getHostId();
        VirtualMachine machine = this.fKnownMachines.get(hostId);
        if (machine != null) {
            return machine;
        }
        String eventName = event.getName();
        if (eventName.startsWith(KVM)) {
            machine = VirtualMachine.newHostMachine(hostId);
        } else if ((eventName.equals("vmsync_gh_guest") || eventName.equals("vmsync_hg_guest")) && (data = (field = (TmfEventField)event.getContent()).getField(new String[]{"vm_uid"})) != null) {
            machine = VirtualMachine.newGuestMachine((Long)data.getValue(), hostId);
        }
        if (machine != null) {
            this.fKnownMachines.put(hostId, machine);
        }
        return machine;
    }

    @Override
    public Set<String> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    private @Nullable VirtualMachine findVmFromParent(ITmfEvent event, HostThread ht) {
        KernelAnalysisModule module = this.getLttngKernelModuleFor(ht.getHost());
        if (module == null) {
            return null;
        }
        Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)ht.getTid(), (long)event.getTimestamp().getValue());
        if (ppid == null) {
            return null;
        }
        HostThread parentHt = new HostThread(ht.getHost(), ppid);
        VirtualMachine vm = this.fTidToVm.get(parentHt);
        if (vm == null) {
            return null;
        }
        this.fTidToVm.put(ht, vm);
        return vm;
    }

    @Override
    public @Nullable VirtualCPU getVCpuExitingHypervisorMode(ITmfEvent event, HostThread ht) {
        String eventName = event.getName();
        if (!eventName.equals("kvm_entry")) {
            return null;
        }
        VirtualMachine vm = this.fTidToVm.get(ht);
        if (vm == null && (vm = this.findVmFromParent(event, ht)) == null) {
            return null;
        }
        ITmfEventField content = event.getContent();
        long vcpu_id = (Long)content.getField(new String[]{"vcpu_id"}).getValue();
        VirtualCPU virtualCPU = VirtualCPU.getVirtualCPU(vm, vcpu_id);
        this.fTidToVcpu.put(ht, virtualCPU);
        return virtualCPU;
    }

    @Override
    public @Nullable VirtualCPU getVCpuEnteringHypervisorMode(ITmfEvent event, HostThread ht) {
        String eventName = event.getName();
        if (!eventName.equals("kvm_exit")) {
            return null;
        }
        return this.getVirtualCpu(ht);
    }

    @Override
    public @Nullable VirtualCPU getVirtualCpu(HostThread ht) {
        return this.fTidToVcpu.get(ht);
    }

    @Override
    public void handleEvent(ITmfEvent event) {
        String eventName = event.getName();
        if (!eventName.equals("vmsync_gh_host")) {
            return;
        }
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        String hostId = event.getTrace().getHostId();
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        ITmfEventField data = content.getField(new String[]{"vm_uid"});
        if (data == null) {
            return;
        }
        long vmUid = (Long)data.getValue();
        for (Map.Entry<String, VirtualMachine> entry : this.fKnownMachines.entrySet()) {
            Integer tid;
            if (entry.getValue().getVmUid() != vmUid) continue;
            KernelAnalysisModule module = this.getLttngKernelModuleFor(hostId);
            if (module == null || (tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)cpu.intValue(), (long)ts)) == null) break;
            HostThread ht = new HostThread(hostId, tid);
            this.fTidToVm.put(ht, entry.getValue());
            Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)tid, (long)ts);
            if (ppid == null) continue;
            HostThread parentHt = new HostThread(hostId, ppid);
            this.fTidToVm.put(parentHt, entry.getValue());
        }
    }

    private @Nullable KernelAnalysisModule getLttngKernelModuleFor(String hostId) {
        return (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)this.fExperiment, (String)hostId, KernelAnalysisModule.class);
    }
}

