/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TcpEventKey;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TcpLttngEventMatching
implements ITmfMatchEventDefinition {
    private static final String @NonNull [] KEY_SEQ = new String[]{"transport_fields", "thtype_tcp", "seq"};
    private static final String @NonNull [] KEY_ACKSEQ = new String[]{"transport_fields", "thtype_tcp", "ack_seq"};
    private static final String @NonNull [] KEY_FLAGS = new String[]{"transport_fields", "thtype_tcp", "flags"};
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"net_dev_queue", (Object)"netif_receive_skb");

    private static boolean canMatchPacket(ITmfEvent event) {
        TmfEventField field = (TmfEventField)event.getContent();
        String[] tcp_data = new String[]{"transport_fields", "thtype_tcp"};
        ITmfEventField data = field.getField(tcp_data);
        if (data != null) {
            return data.getValue() != null;
        }
        return false;
    }

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        ITmfTraceWithPreDefinedEvents ktrace = (ITmfTraceWithPreDefinedEvents)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll((Collection<?>)REQUIRED_EVENTS);
        return !traceEvents.isEmpty();
    }

    public TmfEventMatching.Direction getDirection(ITmfEvent event) {
        String evname = event.getName();
        if (evname.equals("netif_receive_skb") && TcpLttngEventMatching.canMatchPacket(event)) {
            return TmfEventMatching.Direction.EFFECT;
        }
        if (evname.equals("net_dev_queue") && TcpLttngEventMatching.canMatchPacket(event)) {
            return TmfEventMatching.Direction.CAUSE;
        }
        return null;
    }

    public IEventMatchingKey getEventKey(ITmfEvent event) {
        TmfEventField field = (TmfEventField)event.getContent();
        long seq = -1L;
        long ackseq = -1L;
        long flags = -1L;
        ITmfEventField data = field.getField(KEY_SEQ);
        if (data == null) {
            return null;
        }
        seq = (Long)data.getValue();
        data = field.getField(KEY_ACKSEQ);
        if (data == null) {
            return null;
        }
        ackseq = (Long)data.getValue();
        data = field.getField(KEY_FLAGS);
        if (data == null) {
            return null;
        }
        flags = (Long)data.getValue();
        TcpEventKey key = new TcpEventKey(seq, ackseq, flags);
        return key;
    }
}

