/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.SourceCallsite;

public final class FileOffsetMapper {
    private static final String DISCRIMINATOR = "\\(discriminator.*\\)";
    private static final String ADDR2LINE_EXECUTABLE = "addr2line";
    private static final long CACHE_SIZE = 1000L;
    private static final LoadingCache<FileOffset, @Nullable Iterable<SourceCallsite>> CALLSITE_CACHE = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<FileOffset, Iterable<SourceCallsite>>(){

        public @Nullable Iterable<SourceCallsite> load(FileOffset fo) {
            return FileOffsetMapper.getCallsiteFromOffsetWithAddr2line(fo);
        }
    }));

    private FileOffsetMapper() {
    }

    public static @Nullable Iterable<SourceCallsite> getCallsiteFromOffset(File file, String buildId, long offset) {
        if (!Files.exists(file.toPath(), new LinkOption[0])) {
            return null;
        }
        FileOffset fo = new FileOffset((String)NonNullUtils.checkNotNull((Object)file.toString()), buildId, offset);
        return (Iterable)CALLSITE_CACHE.getUnchecked((Object)fo);
    }

    private static @Nullable Iterable<SourceCallsite> getCallsiteFromOffsetWithAddr2line(FileOffset fo) {
        String filePath = fo.fFilePath;
        long offset = fo.fOffset;
        LinkedList<SourceCallsite> callsites = new LinkedList<SourceCallsite>();
        List<String> output = FileOffsetMapper.getOutputFromCommand(Arrays.asList(ADDR2LINE_EXECUTABLE, "-i", "-f", "-C", "-e", filePath, "0x" + Long.toHexString(offset)));
        if (output == null) {
            return null;
        }
        boolean oddLine = false;
        String currentFunctionName = null;
        for (String outputLine : output) {
            oddLine = !oddLine;
            outputLine = outputLine.replaceFirst(DISCRIMINATOR, "").trim();
            if (oddLine) {
                currentFunctionName = outputLine;
                continue;
            }
            String[] elems = outputLine.split(":");
            String fileName = elems[0];
            if (fileName.equals("??")) continue;
            try {
                long lineNumber = Long.parseLong(elems[1]);
                callsites.add(new SourceCallsite(fileName, currentFunctionName, lineNumber));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return callsites;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable List<String> getOutputFromCommand(List<String> command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process p = builder.start();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                int ret = p.waitFor();
                List<String> lines = br.lines().collect(Collectors.toList());
                return ret == 0 ? lines : null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    private static class FileOffset {
        private final String fFilePath;
        private final String fBuildId;
        private final long fOffset;

        public FileOffset(String filePath, String buildId, long offset) {
            this.fFilePath = filePath;
            this.fBuildId = buildId;
            this.fOffset = offset;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fFilePath, this.fBuildId, this.fOffset});
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileOffset other = (FileOffset)obj;
            return Objects.equal((Object)this.fFilePath, (Object)other.fFilePath) && Objects.equal((Object)this.fBuildId, (Object)other.fBuildId) && Objects.equal((Object)this.fOffset, (Object)other.fOffset);
        }
    }
}

