/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class UstDebugInfoBinaryFile
implements Comparable<UstDebugInfoBinaryFile> {
    private final String fFilePath;
    private final String fBuildId;
    private final boolean fIsPic;
    private final String fToString;

    public UstDebugInfoBinaryFile(String filePath, String buildId, boolean isPic) {
        this.fFilePath = filePath;
        this.fBuildId = buildId;
        this.fIsPic = isPic;
        this.fToString = String.valueOf(filePath) + " (" + (this.fIsPic ? "PIC" : "non-PIC") + ", " + buildId + ')';
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public String getBuildId() {
        return this.fBuildId;
    }

    public boolean isPic() {
        return this.fIsPic;
    }

    public String toString() {
        return this.fToString;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof UstDebugInfoBinaryFile)) {
            return false;
        }
        UstDebugInfoBinaryFile other = (UstDebugInfoBinaryFile)obj;
        return this.fFilePath.equals(other.fFilePath) && this.fBuildId.equals(other.fBuildId) && this.fIsPic == other.fIsPic;
    }

    public int hashCode() {
        return Objects.hash(this.fBuildId, this.fFilePath, this.fIsPic);
    }

    @Override
    public int compareTo(@Nullable UstDebugInfoBinaryFile o) {
        if (o == null) {
            return 1;
        }
        return this.fFilePath.compareTo(o.fFilePath);
    }
}

